/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.entity.genentity;

import com.bokesoft.erp.entity.genentity.IEntityNameHelper;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.util.FileUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class EntityNameHelper
implements IEntityNameHelper {
    public static final String STR_Empty = "Empty__";
    private Map<String, String> fieldNames = null;
    private HashMap<String, String> capTableNames;
    private HashMap<String, String> decapTableNames;

    public String capitalizeName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            name = STR_Empty;
        }
        if (name.startsWith("com.bokesoft.")) {
            return name;
        }
        return StringUtils.capitalize((String)name);
    }

    public String decapitalizeName(String name) {
        return StringUtils.uncapitalize((String)name);
    }

    @Override
    public String capitalizeFieldName(String fieldName) throws Throwable {
        if (!TypeConvertor.toBoolean((Object)System.getProperty("ERPFieldDictionaryTool")).booleanValue() && this.fieldNames == null) {
            String srcPath;
            File srcFile;
            if (this.fieldNames == null) {
                this.fieldNames = new HashMap<String, String>();
            }
            if ((srcFile = new File(srcPath = String.valueOf(EntityNameHelper.class.getResource("/").toURI().getPath()) + "GEN.Dictionary")).exists()) {
                String dicStr = FileUtil.File2String((String)srcPath, (String)"UTF-8");
                String[] dics = StringUtil.split((String)dicStr, (String)"\n");
                int i = 0;
                while (i < dics.length) {
                    String[] tmp = StringUtil.split((String)dics[i], (String)" ");
                    if (!this.fieldNames.containsKey(tmp[0].trim().toLowerCase())) {
                        this.fieldNames.put(tmp[0].trim().toLowerCase(), tmp[0].trim());
                    }
                    ++i;
                }
            }
        }
        if (this.fieldNames != null && this.fieldNames.containsKey(fieldName.toLowerCase())) {
            return this.fieldNames.get(fieldName.toLowerCase());
        }
        return fieldName;
    }

    @Override
    public String decapitalizeFieldName(String fieldName) {
        return this.decapitalizeName(fieldName);
    }

    @Override
    public String capitalizeTableName(String tableName) {
        if (this.capTableNames == null) {
            this.capTableNames = new HashMap();
        }
        if (!this.capTableNames.containsKey(tableName)) {
            String r;
            int pos = tableName.indexOf("_");
            int length = tableName.length();
            StringBuilder result = new StringBuilder(length);
            if (pos > 0) {
                result.append(tableName.substring(0, pos).toUpperCase()).append("_");
                if (pos < length - 1) {
                    result.append(tableName.substring(pos + 1, pos + 2).toUpperCase()).append(tableName.substring(pos + 2));
                }
                r = result.toString();
            } else {
                r = StringUtils.capitalize((String)tableName);
            }
            this.capTableNames.put(tableName, r);
        }
        return this.capTableNames.get(tableName);
    }

    @Override
    public String decapitalizeTableName(String tableName) {
        if (this.decapTableNames == null) {
            this.decapTableNames = new HashMap();
        }
        if (!this.decapTableNames.containsKey(tableName)) {
            String r;
            int pos = tableName.indexOf("_");
            int length = tableName.length();
            StringBuilder result = new StringBuilder(length);
            if (pos > 0) {
                result.append(tableName.substring(0, pos).toLowerCase()).append("_");
                if (pos < length - 1) {
                    result.append(tableName.substring(pos + 1, pos + 2).toLowerCase()).append(tableName.substring(pos + 2));
                }
                r = result.toString();
            } else {
                r = StringUtils.uncapitalize((String)tableName);
            }
            this.decapTableNames.put(tableName, r);
        }
        return this.decapTableNames.get(tableName);
    }

    @Override
    public String capitalizeBillName(String billName) {
        return this.capitalizeName(billName);
    }

    @Override
    public String decapitalizeBillName(String billName) {
        return this.decapitalizeName(billName);
    }

    public String formatFieldKey(String fieldKey) {
        if (!fieldKey.contains("_") || fieldKey.contains("___Mirror")) {
            return fieldKey;
        }
        StringBuilder result = new StringBuilder();
        String[] fieldKeyArray = fieldKey.split("_");
        int i = 0;
        while (i < fieldKeyArray.length) {
            result.append(StringUtils.capitalize((String)fieldKeyArray[i]));
            result.append("_");
            ++i;
        }
        if (result.length() == 0) {
            return fieldKey;
        }
        result.delete(result.length() - 1, result.length());
        String r = result.toString();
        r = EntityNameHelper.replaceAllIngoreCase(r, "__Mirror", "__mirror");
        return r;
    }

    public static String replaceAllIngoreCase(String template, String placeholder, String replacement) {
        if (template == null) {
            return "";
        }
        int loc = StringUtils.indexOfIgnoreCase((CharSequence)template, (CharSequence)placeholder);
        if (loc < 0) {
            return template;
        }
        return new StringBuffer(template.substring(0, loc)).append(replacement).append(EntityNameHelper.replaceAllIngoreCase(template.substring(loc + placeholder.length()), placeholder, replacement)).toString();
    }

    public static String getNewClassFunctionName(String oldClassFunctionName, int paraCount) {
        String className = oldClassFunctionName.substring(0, oldClassFunctionName.lastIndexOf("."));
        String functionName = oldClassFunctionName.substring(className.length() + 1);
        try {
            Class<?> clz = Class.forName(className);
            Method[] methodArray = clz.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                int modifiers = method.getModifiers();
                if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getName().equalsIgnoreCase(functionName) && method.getParameterCount() == paraCount) {
                    return className.concat(".").concat(method.getName());
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return oldClassFunctionName;
    }
}

