/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import java.util.Map;
import java.util.Set;

public class LRUCacheNew<K, V> {
    private final int MAX_CACHE_SIZE;
    private ConcurrentLinkedHashMap<K, V> map;
    private V nullKeyToValue;

    public LRUCacheNew(int cacheSize) {
        this.MAX_CACHE_SIZE = cacheSize;
        this.map = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)this.MAX_CACHE_SIZE).weigher(Weighers.singleton()).build();
    }

    public void put(K key, V value) {
        if (key == null) {
            this.nullKeyToValue = value;
            return;
        }
        this.map.put(key, value);
    }

    public V get(K key) {
        if (key == null) {
            return this.nullKeyToValue;
        }
        return (V)this.map.get(key);
    }

    public void remove(K key) {
        if (key == null) {
            this.nullKeyToValue = null;
            return;
        }
        this.map.remove(key);
    }

    public Set<Map.Entry<K, V>> getAll() {
        return this.map.entrySet();
    }

    public void clear() {
        this.nullKeyToValue = null;
        this.map.clear();
    }
}

