/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.thread;

import com.bokesoft.erp.thread.MultiThreadTask;
import com.bokesoft.erp.thread.MultithreadWorker;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.base.MidVEUtil;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class MultiThreadService {
    private RichDocumentContext a;
    private static int defaultThreadNum = 1;
    private static int coutDownSize = 0;

    public MultiThreadService(RichDocumentContext richDocumentContext, int n, int n2) {
        this.a = richDocumentContext;
        coutDownSize = n2;
        defaultThreadNum = n;
    }

    public MultiThreadService(int n) {
        defaultThreadNum = n;
    }

    public List<Future<Object>> execute(List<MultiThreadTask> list) throws Throwable {
        String string = Thread.currentThread().getName();
        CustomizableThreadFactory customizableThreadFactory = new CustomizableThreadFactory();
        customizableThreadFactory.setThreadNamePrefix(String.valueOf(string) + "-SonThread-");
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(defaultThreadNum, defaultThreadNum, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)customizableThreadFactory);
        ArrayList<Future<Object>> arrayList = new ArrayList<Future<Object>>();
        if (coutDownSize > 0) {
            CountDownLatch countDownLatch = new CountDownLatch(list.size());
            try {
                try {
                    MidVEUtil.newMidVE();
                    for (MultiThreadTask multiThreadTask : list) {
                        RichDocumentContext richDocumentContext = null;
                        try {
                            try {
                                richDocumentContext = this.a.newMidContext();
                                MultithreadWorker multithreadWorker = new MultithreadWorker(richDocumentContext, countDownLatch, multiThreadTask);
                                Future<Object> future = threadPoolExecutor.submit(multithreadWorker);
                                arrayList.add(future);
                            }
                            catch (Exception exception) {
                                if (richDocumentContext != null) {
                                    richDocumentContext.rollback();
                                }
                                if (richDocumentContext == null) continue;
                                richDocumentContext.commit();
                                richDocumentContext.close();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            if (richDocumentContext != null) {
                                richDocumentContext.commit();
                                richDocumentContext.close();
                            }
                            throw throwable;
                        }
                        if (richDocumentContext == null) continue;
                        richDocumentContext.commit();
                        richDocumentContext.close();
                    }
                }
                catch (Exception exception) {
                    LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
                    threadPoolExecutor.shutdown();
                    MidVEUtil.clearThreadLocalData();
                    countDownLatch.await();
                    threadPoolExecutor.shutdown();
                }
            }
            finally {
                MidVEUtil.clearThreadLocalData();
                countDownLatch.await();
                threadPoolExecutor.shutdown();
            }
        } else {
            try {
                try {
                    MidVEUtil.newMidVE();
                    for (MultiThreadTask multiThreadTask : list) {
                        RichDocumentContext richDocumentContext = null;
                        try {
                            try {
                                richDocumentContext = this.a.newMidContext();
                                MultithreadWorker multithreadWorker = new MultithreadWorker(richDocumentContext, multiThreadTask);
                                Future<Object> future = threadPoolExecutor.submit(multithreadWorker);
                                arrayList.add(future);
                            }
                            catch (Exception exception) {
                                if (richDocumentContext != null) {
                                    richDocumentContext.rollback();
                                }
                                if (richDocumentContext == null) continue;
                                richDocumentContext.commit();
                                richDocumentContext.close();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            if (richDocumentContext != null) {
                                richDocumentContext.commit();
                                richDocumentContext.close();
                            }
                            throw throwable;
                        }
                        if (richDocumentContext == null) continue;
                        richDocumentContext.commit();
                        richDocumentContext.close();
                    }
                }
                catch (Exception exception) {
                    LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
                    threadPoolExecutor.shutdown();
                    MidVEUtil.clearThreadLocalData();
                    threadPoolExecutor.shutdown();
                }
            }
            finally {
                MidVEUtil.clearThreadLocalData();
                threadPoolExecutor.shutdown();
            }
        }
        return arrayList;
    }
}

