/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.authority.setup.util;

import com.bokesoft.erp.authority.setup.base.InitialFileAgent;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.XmlParser;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TextNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class XmlParserUtil {
    public static TagNode parse(InitialFileAgent initialFileAgent) throws Throwable {
        String string = XmlParserUtil.getXml(initialFileAgent);
        XmlTree xmlTree = XmlParserUtil.a(string);
        return xmlTree.getRoot();
    }

    private static XmlTree a(String string) {
        return XmlParser.parse((String)string, (boolean)true);
    }

    public static String getXml(InitialFileAgent initialFileAgent) throws Throwable {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream inputStream = initialFileAgent.getInputStream();){
            return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String toXml(TagNode tagNode) {
        return XmlParserUtil.a(tagNode, 0);
    }

    public static boolean deleteChildByAttrValues(TagNode tagNode, String[] stringArray, String[] stringArray2) {
        boolean bl = false;
        Iterator iterator = tagNode.getChildren().iterator();
        while (iterator.hasNext()) {
            AbstractNode abstractNode = (AbstractNode)iterator.next();
            if (!(abstractNode instanceof TagNode)) continue;
            boolean bl2 = true;
            TagNode tagNode2 = (TagNode)abstractNode;
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                String string2 = stringArray2[n];
                String string3 = (String)tagNode2.getAttributes().get(string);
                if (!string2.equals(string3)) {
                    bl2 = false;
                    break;
                }
                ++n;
            }
            if (!bl2) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static TagNode findTagNodeByAttrs(List<AbstractNode> list, String[] stringArray, String[] stringArray2) {
        if (list == null || stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return null;
        }
        String string = null;
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof TagNode)) continue;
            boolean bl = true;
            int n = 0;
            while (n < stringArray.length) {
                string = (String)((TagNode)abstractNode).getAttributes().get(stringArray[n]);
                if (!TypeConvertor.toString((Object)stringArray2[n]).equals(string)) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (!bl) continue;
            return (TagNode)abstractNode;
        }
        return null;
    }

    public static List<TagNode> findTagNodesByAttrs(List<AbstractNode> list, String[] stringArray, String[] stringArray2) {
        ArrayList<TagNode> arrayList = new ArrayList<TagNode>();
        if (list == null || stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return null;
        }
        String string = null;
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof TagNode)) continue;
            boolean bl = true;
            int n = 0;
            while (n < stringArray.length) {
                string = (String)((TagNode)abstractNode).getAttributes().get(stringArray[n]);
                if (!TypeConvertor.toString((Object)stringArray2[n]).equals(string)) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (!bl) continue;
            arrayList.add((TagNode)abstractNode);
        }
        return arrayList;
    }

    public static TagNode findTagNodeByPrimary(String string, String string2, List<AbstractNode> list) {
        if (list == null || string2 == null) {
            return null;
        }
        if (StringUtil.isBlankOrNull((String)string)) {
            return null;
        }
        String string3 = null;
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof TagNode) || !string2.equals(string3 = (String)((TagNode)abstractNode).getAttributes().get(string))) continue;
            return (TagNode)abstractNode;
        }
        return null;
    }

    public static TagNode getLastChildTagNode(String string, TagNode tagNode) {
        if (tagNode == null || tagNode.getChildren() == null) {
            return null;
        }
        AbstractNode abstractNode = null;
        List list = tagNode.getChildren();
        int n = list.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            TagNode tagNode2;
            abstractNode = (AbstractNode)list.get(n2);
            if (abstractNode instanceof TagNode && string.equals((tagNode2 = (TagNode)abstractNode).getTagName())) {
                return tagNode2;
            }
            --n2;
        }
        return null;
    }

    private static String a(TagNode tagNode, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n == 0) {
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n");
            XmlParserUtil.a(stringBuilder, (AbstractNode)tagNode, n);
        }
        XmlParserUtil.a(stringBuilder, n);
        String string = XmlParserUtil.a(tagNode);
        String string2 = tagNode.getTagName();
        List list = tagNode.getChildren();
        stringBuilder.append("<").append(tagNode.getTagName());
        if (!StringUtil.isEmptyStr((String)string)) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(string);
        if (list.size() > 0) {
            stringBuilder.append(">").append("\r\n");
            for (AbstractNode abstractNode : list) {
                XmlParserUtil.a(stringBuilder, abstractNode, n + 1);
                if (abstractNode instanceof TextNode && (abstractNode.getText() == null || abstractNode.getText().trim().length() == 0)) continue;
                if (abstractNode instanceof TagNode) {
                    stringBuilder.append(XmlParserUtil.a((TagNode)abstractNode, n + 1)).append("\r\n");
                } else {
                    stringBuilder.append(abstractNode.toXml(n + 1)).append("\r\n");
                }
                XmlParserUtil.b(stringBuilder, abstractNode, n + 1);
            }
            XmlParserUtil.a(stringBuilder, n);
            stringBuilder.append("</").append(string2).append(">");
        } else {
            stringBuilder.append("/>");
        }
        if (n == 0) {
            stringBuilder.append("\r\n");
            XmlParserUtil.b(stringBuilder, (AbstractNode)tagNode, n);
        }
        return stringBuilder.toString();
    }

    private static void a(StringBuilder stringBuilder, AbstractNode abstractNode, int n) {
        List list = abstractNode.getPreComment();
        if (list == null) {
            return;
        }
        for (AbstractNode abstractNode2 : list) {
            stringBuilder.append(abstractNode2.toXml(n)).append("\r\n");
        }
    }

    private static void b(StringBuilder stringBuilder, AbstractNode abstractNode, int n) {
        List list = abstractNode.getLastComment();
        if (list == null) {
            return;
        }
        for (AbstractNode abstractNode2 : list) {
            stringBuilder.append(abstractNode2.toXml(n)).append("\r\n");
        }
    }

    private static String a(TagNode tagNode) {
        String string = "";
        for (Map.Entry entry : tagNode.getAttributes().entrySet()) {
            string = string.length() == 0 ? String.valueOf((String)entry.getKey()) + "=\"" + XmlParserUtil.b((String)entry.getValue()) + "\"" : String.valueOf(string) + " " + (String)entry.getKey() + "=\"" + XmlParserUtil.b((String)entry.getValue()) + "\"";
        }
        return string;
    }

    private static void a(StringBuilder stringBuilder, int n) {
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append("    ");
            ++n2;
        }
    }

    private static String b(String string) {
        return string;
    }
}

