/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.authority.repair.util;

import com.bokesoft.erp.authority.repair.FormAuthorityManager;
import com.bokesoft.erp.authority.repair.entity.AuthorityClassObject;
import com.bokesoft.erp.authority.repair.entity.AuthorityTCode;
import com.bokesoft.erp.authority.repair.form.AuthorityForm;
import com.bokesoft.erp.authority.repair.form.AuthorityFormEntry;
import com.bokesoft.erp.authority.repair.form.AuthorityFormInitContext;
import com.bokesoft.erp.authority.repair.traversal.AuthorityVisitor4FormField;
import com.bokesoft.erp.authority.repair.util.AuthorityGlobalUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.util.ERPDataTableUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.Item;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AuthorityFormUtil {
    public static DataTable loadAuthorityFormTable(String string, String string2, RichDocumentContext richDocumentContext) throws Throwable {
        MetaForm metaForm = richDocumentContext.getMetaFactory().getMetaForm("InitFormAuthorityConfig");
        DataTable dataTable = ERPDataTableUtil.generateDataTable((MetaForm)metaForm, (String)"EBK_FormAuthorityUnInited");
        Collection<AuthorityForm> collection = FormAuthorityManager.getInstance().getAuthorityFormList(richDocumentContext);
        for (AuthorityForm authorityForm : collection) {
            String string3 = authorityForm.getKey();
            String string4 = authorityForm.getCaption();
            String string5 = authorityForm.getProjectKey();
            if (!StringUtil.isBlankOrNull((String)string) && !string5.equalsIgnoreCase(string)) continue;
            if (authorityForm.hasEntry()) {
                AuthorityFormEntry[] authorityFormEntryArray = authorityForm.getAuthorityFormEntries();
                int n = authorityFormEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AuthorityFormEntry authorityFormEntry = authorityFormEntryArray[n2];
                    if (!authorityFormEntry.hasTCode()) {
                        AuthorityFormUtil.addAuthorityFormInfoRow(string3, string4, authorityFormEntry.getKey(), string5, false, false, true, string2, null, dataTable);
                    }
                    ++n2;
                }
                continue;
            }
            if (authorityForm.hasTCode()) continue;
            AuthorityFormUtil.addAuthorityFormInfoRow(string3, string4, "_", string5, false, false, false, string2, null, dataTable);
        }
        return dataTable;
    }

    public static AuthorityForm buildInitFormAuthority(String string, String string2, String string3, AuthorityFormInitContext authorityFormInitContext) throws Throwable {
        AuthorityForm authorityForm = authorityFormInitContext.ensureAuthorityForm(string);
        string3 = StringUtil.isBlankOrNull((String)string3) ? authorityForm.getDefaultTCodeKey() : string3;
        AuthorityTCode authorityTCode = AuthorityFormUtil.a(string3, authorityForm, authorityFormInitContext);
        AuthorityFormUtil.a(authorityTCode, string2, authorityForm);
        AuthorityFormUtil.a(authorityForm, authorityFormInitContext);
        return authorityForm;
    }

    public static DataTable loadAuthorityFormField(String string, String string2, RichDocumentContext richDocumentContext) throws Throwable {
        MetaForm metaForm = richDocumentContext.getMetaFactory().getMetaForm("InitFormAuthorityConfig");
        DataTable dataTable = ERPDataTableUtil.generateDataTable((MetaForm)metaForm, (String)"EBK_AuthorityObjectDetail");
        if (StringUtil.isBlankOrNull((String)string)) {
            return dataTable;
        }
        AuthorityFormInitContext authorityFormInitContext = new AuthorityFormInitContext(richDocumentContext);
        AuthorityForm authorityForm = AuthorityFormUtil.buildInitFormAuthority(string, string2, "", authorityFormInitContext);
        authorityForm.traversal(new AuthorityVisitor4FormField(dataTable, richDocumentContext));
        return dataTable;
    }

    private static AuthorityTCode a(String string, AuthorityForm authorityForm, AuthorityFormInitContext authorityFormInitContext) throws Throwable {
        AuthorityTCode authorityTCode = authorityFormInitContext.ensureAuthorityDefalutTCode(string, authorityForm);
        authorityTCode.addFormKey(authorityForm.getKey());
        authorityForm.addTCode(authorityTCode);
        return authorityTCode;
    }

    private static AuthorityFormEntry a(AuthorityTCode authorityTCode, String string, AuthorityForm authorityForm) {
        AuthorityFormEntry authorityFormEntry = new AuthorityFormEntry(string, authorityForm.getKey());
        authorityFormEntry.addTCode(authorityTCode);
        authorityForm.addEntry(authorityFormEntry);
        return authorityFormEntry;
    }

    private static AuthorityClassObject a(AuthorityForm authorityForm, AuthorityFormInitContext authorityFormInitContext) throws Throwable {
        AuthorityTCode authorityTCode = authorityForm.getDefaultTCode();
        if (authorityTCode == null) {
            return null;
        }
        AuthorityClassObject authorityClassObject = authorityFormInitContext.ensureAuthorityObject(authorityForm);
        authorityTCode.addAuthorityObject(authorityClassObject);
        return authorityClassObject;
    }

    public static void addAuthorityFormInfoRow(String string, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3, String string5, Set<String> set, DataTable dataTable) {
        if (StringUtil.isBlankOrNull((String)string5) || string.toUpperCase().contains(string5.toUpperCase()) || string2.toUpperCase().contains(string5.toUpperCase()) || set != null && set.contains(string5.toUpperCase())) {
            int n = dataTable.append();
            dataTable.setString(n, "FormKey", string);
            dataTable.setString(n, "FormCaption", string2);
            dataTable.setString(n, "EntryKey", string3);
            dataTable.setString(n, "Module", string4);
            dataTable.setInt(n, "IsIgnoreFormAuth", Integer.valueOf(bl ? 1 : 0));
            dataTable.setInt(n, "IsControlFormAuth", Integer.valueOf(bl2 ? 1 : 0));
            dataTable.setInt(n, "HasEntry", Integer.valueOf(bl3 ? 1 : 0));
            dataTable.setState(0);
        }
    }

    public static void addAuthorityFieldInfoRow(String string, String string2, String string3, String string4, int n, int n2, String string5, String string6, int n3, DataTable dataTable) {
        int n4 = dataTable.append();
        dataTable.setString(n4, "FieldKey", string);
        dataTable.setString(n4, "FieldCaption", string2);
        dataTable.setString(n4, "DataElementKey", string3);
        dataTable.setString(n4, "AuthoritySource", string4);
        dataTable.setInt(n4, "IsIgnoreFieldAuth", Integer.valueOf(n));
        dataTable.setInt(n4, "IsControlFieldAuth", Integer.valueOf(n2));
        dataTable.setString(n4, "AuthorityObjectCode", string5);
        dataTable.setString(n4, "FieldTCode", string6);
        dataTable.setInt(n4, "CanCancelControl", Integer.valueOf(n3));
        dataTable.setState(0);
    }

    public static Set<String> getTCodeByFormKey(String string, RichDocumentContext richDocumentContext) throws Throwable {
        SqlString sqlString = new SqlString().append(new Object[]{"select ", "SOID", " from ", "EGS_TCode_FormList", " where ", "FormKey", "="}).appendPara((Object)string);
        HashSet<String> hashSet = new HashSet<String>();
        DataTable dataTable = richDocumentContext.getResultSet(sqlString);
        dataTable.beforeFirst();
        while (dataTable.next()) {
            String string2;
            long l = dataTable.getLong("SOID");
            Item item = richDocumentContext.getDicItem("TCode", Long.valueOf(l));
            if (item == null || !StringUtil.isBlankOrNull((String)(string2 = TypeConvertor.toString((Object)item.getValue("Code"))))) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public static List<String> getTCodeByEntryKey(String string, RichDocumentContext richDocumentContext) throws Throwable {
        SqlString sqlString = new SqlString().append(new Object[]{"select ", "OID", ",", "EntryKey", ",", "RefFormKey", ",", "EntryTCode", " from ", "EAU_EntryTCodeRelation", " where ", "EntryKey", "="}).appendPara((Object)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        DataTable dataTable = richDocumentContext.getResultSet(sqlString);
        dataTable.beforeFirst();
        while (dataTable.next()) {
            long l = dataTable.getLong("OID");
            String string2 = dataTable.getString("EntryTCode");
            arrayList.add(string2);
            List<String> list = AuthorityFormUtil.getOptTCodeSOID(l, richDocumentContext);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static List<String> getOptTCodeSOID(Long l, RichDocumentContext richDocumentContext) throws Throwable {
        SqlString sqlString = new SqlString().append(new Object[]{"select ", "SOID", ",", "TCode", " from ", "EAU_EntryOptTCodeRelation", " where ", "SOID", "="}).appendPara((Object)l);
        DataTable dataTable = richDocumentContext.getResultSet(sqlString);
        ArrayList<String> arrayList = new ArrayList<String>();
        dataTable.beforeFirst();
        while (dataTable.next()) {
            String string = dataTable.getString("TCode");
            if (StringUtil.isBlankOrNull((String)string) || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static Set<String> getEntryList(String string, IMetaFactory iMetaFactory) throws Throwable {
        HashSet<String> hashSet = new HashSet<String>();
        AuthorityFormUtil.a(string, hashSet, iMetaFactory.getEntryList(""));
        return hashSet;
    }

    private static void a(String string, Set<String> set, MetaEntry metaEntry) {
        int n = metaEntry.size();
        int n2 = 0;
        while (n2 < n) {
            MetaEntryItem metaEntryItem;
            String string2;
            AbstractCompositeObject abstractCompositeObject = metaEntry.get(n2);
            if (abstractCompositeObject.getCompositeType() == 1) {
                AuthorityFormUtil.a(string, set, (MetaEntry)abstractCompositeObject);
            } else if (abstractCompositeObject.getCompositeType() == 0 && string.equalsIgnoreCase(string2 = AuthorityGlobalUtil.getFormKeyByEntryItem(metaEntryItem = (MetaEntryItem)abstractCompositeObject))) {
                String string3 = metaEntryItem.getKey();
                set.add(string3);
            }
            ++n2;
        }
    }
}

