/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.InitializeData;

import com.bokesoft.erp.InitializeData.Graph;
import com.bokesoft.erp.InitializeData.INodeElement;
import com.bokesoft.erp.InitializeData.TestFormula;
import com.bokesoft.yes.common.log.ILogSvr;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.log.NullLogSvr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.function.FailableConsumer;

public class GraphParallelProcessor {
    public static void processGraphMultiThread(List<INodeElement> list, FailableConsumer<INodeElement, Throwable> failableConsumer) {
        if (list.isEmpty()) {
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(list.size(), Runtime.getRuntime().availableProcessors()));
        HashMap<String, CompletionStage> hashMap = new HashMap<String, CompletionStage>();
        for (INodeElement iNodeElement : list) {
            List<String> list2 = iNodeElement.getInputKeys();
            ArrayList<CompletableFuture> arrayList = new ArrayList<CompletableFuture>();
            if (list2 != null) {
                for (String string : list2) {
                    CompletableFuture completableFuture = (CompletableFuture)hashMap.get(string);
                    if (completableFuture == null) continue;
                    arrayList.add(completableFuture);
                }
            }
            CompletionStage object2 = CompletableFuture.allOf(arrayList.toArray(new CompletableFuture[0])).thenRunAsync(() -> {
                try {
                    failableConsumer.accept((Object)iNodeElement);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.rethrow((Throwable)throwable);
                }
            }, executorService);
            hashMap.put(iNodeElement.getKey(), object2);
        }
        try {
            CompletableFuture.allOf(hashMap.values().toArray(new CompletableFuture[0])).join();
        }
        finally {
            executorService.shutdown();
        }
    }

    public static <T> List<T> processListMultiThread(List<Callable<T>> list) throws Throwable {
        if (list.isEmpty()) {
            return new ArrayList();
        }
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(list.size(), Runtime.getRuntime().availableProcessors()));
        try {
            ArrayList<T> arrayList = new ArrayList<T>();
            List<Future<T>> list2 = executorService.invokeAll(list);
            for (Future<T> future : list2) {
                arrayList.add(future.get());
            }
            ArrayList<T> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            executorService.shutdown();
        }
    }

    public static <T> void processListMultiThread(List<T> list, FailableConsumer<T, Throwable> failableConsumer) throws Throwable {
        ArrayList<Callable<T>> arrayList = new ArrayList<Callable<T>>();
        for (Object t : list) {
            Callable<Object> callable = () -> {
                try {
                    failableConsumer.accept(t);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                return t;
            };
            arrayList.add(callable);
        }
        GraphParallelProcessor.processListMultiThread(arrayList);
    }

    public static void main(String[] stringArray) throws Throwable {
        LogSvr.setInstance((ILogSvr)new NullLogSvr());
        Graph graph = new Graph();
        graph.addElement(new TestFormula("C", "D,E", "C=D+E"));
        graph.addElement(new TestFormula("A", "B,C", "A=B+C"));
        graph.addElement(new TestFormula("E", "F,G", "E=F+G"));
        graph.addElement(new TestFormula("G", "H", "G=H"));
        graph.addElement(new TestFormula("H", "G", "H=G"));
        graph.addElement(new TestFormula("P", null, "P=1"));
        graph.addElement(new TestFormula("Z", "B", "Z=B"));
        graph.addElement(new TestFormula("X", "C", "X=C"));
        graph.createGraph();
        LinkedList<INodeElement> linkedList = new LinkedList<INodeElement>();
        if (!graph.topoSort(linkedList, null)) {
            linkedList = graph.resolveCyclesAndTopoSort();
        }
        GraphParallelProcessor.processGraphMultiThread(linkedList, (FailableConsumer<INodeElement, Throwable>)((FailableConsumer)iNodeElement -> {
            if (iNodeElement.getKey().equals("C")) {
                Thread.sleep(2000L);
            }
            iNodeElement.getKey().equals("E");
            ((TestFormula)iNodeElement).a();
        }));
    }
}

