/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import com.bokesoft.yes.mid.base.ServerSetting;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalSchedulerUtil {
    private static final Logger log = LoggerFactory.getLogger(AdditionalSchedulerUtil.class);

    public static void registerJob(String jobName, String jobGroup, Class<? extends Job> jobClass, String cronExpression) throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(new JobKey(jobName, jobGroup)).build();
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
        AdditionalSchedulerUtil.registerJob(jobDetail, (Trigger)trigger);
    }

    public static void registerJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        if (AdditionalSchedulerUtil.checkJobExist(jobDetail.getKey().getName(), jobDetail.getKey().getGroup())) {
            log.info("Scheduler Job already exist, JobKey:[name:{},group:{}]", (Object)jobDetail.getKey().getName(), (Object)jobDetail.getKey().getGroup());
            return;
        }
        ServerSetting serverSetting = ServerSetting.getInstance();
        if (serverSetting != null && serverSetting.isReadOnly()) {
            return;
        }
        try {
            Scheduler scheduler = AdditionalSchedulerUtil.getScheduler();
            scheduler.scheduleJob(jobDetail, trigger);
            scheduler.start();
            String triggerInfo = trigger.getDescription();
            if (trigger instanceof CronTrigger) {
                triggerInfo = "cron-expression=" + ((CronTrigger)trigger).getCronExpression();
            }
            log.info("Add Scheduler Job:{}, JobImpl:{}, TriggerInfo:{}", new Object[]{jobDetail.getKey(), jobDetail.getJobClass(), triggerInfo});
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public static void deleteJob(String jobName, String jobGroup) throws SchedulerException {
        if (!AdditionalSchedulerUtil.checkJobExist(jobName, jobGroup)) {
            log.info("Scheduler Job not exist, JobKey:[name:{},group:{}]", (Object)jobName, (Object)jobGroup);
            return;
        }
        ServerSetting serverSetting = ServerSetting.getInstance();
        if (serverSetting != null && serverSetting.isReadOnly()) {
            return;
        }
        try {
            Scheduler scheduler = AdditionalSchedulerUtil.getScheduler();
            scheduler.deleteJob(new JobKey(jobName, jobGroup));
            log.info("Delete Scheduler, JobKey:[name:{},group:{}]", (Object)jobName, (Object)jobGroup);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public static boolean checkJobExist(String jobName, String jobGroup) throws SchedulerException {
        try {
            Scheduler scheduler = AdditionalSchedulerUtil.getScheduler();
            return scheduler.checkExists(new JobKey(jobName, jobGroup));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    private static Object getQuartzManager() throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Object quartzManager;
        try {
            Class<?> quartzManagerClass = Class.forName("com.bokesoft.yigo.mid.scheduler.QuartzManager");
            quartzManager = MethodUtils.invokeStaticMethod(quartzManagerClass, (String)"getInstance", (Object[])new Object[0]);
        }
        catch (ClassNotFoundException e) {
            Class<?> quartzManagerClass = Class.forName("com.bokesoft.yes.mid.scheduler.QuartzManager");
            quartzManager = MethodUtils.invokeStaticMethod(quartzManagerClass, (String)"getInstance", (Object[])new Object[0]);
        }
        return quartzManager;
    }

    private static Scheduler getScheduler() throws SchedulerException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Object quartzManager = AdditionalSchedulerUtil.getQuartzManager();
        SchedulerFactory schedulerFactory = (SchedulerFactory)FieldUtils.readField((Object)quartzManager, (String)"schedulerFactory", (boolean)true);
        return schedulerFactory.getScheduler();
    }
}

