/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.auth;

import com.bokesoft.distro.tech.commons.basis.auth.CrossAuthUtil;
import com.bokesoft.yigo.mid.para.SysPara;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossAuthHelper {
    private static Logger logger = LoggerFactory.getLogger(CrossAuthHelper.class);

    public static boolean doAuth(HttpServletRequest request) {
        String authStr = CrossAuthHelper.getTokenString(request);
        return CrossAuthHelper.doAuth(authStr);
    }

    private static boolean doAuth(String authStr) {
        try {
            return CrossAuthUtil.doCheck((String)SysPara.getInstance().get("PrivateKey"), (String)authStr);
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u89e3\u6790Auth\u52a0\u5bc6\u4fe1\u606f", (Throwable)e);
            return false;
        }
    }

    private static String getTokenString(HttpServletRequest request) {
        String tokenStr = request.getHeader("x-bk-cross-auth");
        if (StringUtils.isNotBlank((CharSequence)tokenStr)) {
            return tokenStr;
        }
        return request.getParameter("x-bk-cross-auth");
    }
}

