package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import java.sql.Connection;
import java.sql.SQLException;
import com.bokesoft.distro.tech.commons.basis.jdbc.DBTypeUtils;
import com.bokesoft.distro.tech.yigosupport.extension.intf.IJDBCCompatible;
import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import org.apache.commons.lang3.reflect.FieldUtils;

public class YigoDBHelper {
    /**
     * 根据原有的数据查询 SQL 语句获取获取其数据总数的 SQL 数据
     *
     * @param context yigo上下文
     * @param sql sql语句
     * @param countColumnName SQL 语句中对于总数的字段名
     * @return
     * @throws SQLException
     */
    public static String getCountSql(DefaultContext context, String sql, String countColumnName) throws SQLException {
        return DBTypeUtils.getCountSql(sql, countColumnName, getJdbcurl(context));
    }

    /**
     * 包装 SQL 语句产生用于分页查询的 SQL 语句
     *
     * @param context yigo上下文
     * @param sql sql语句
     * @param pageNo 当前页码
     * @param pageSize 页大小
     * @return
     */
    public static String adaptSqlRange(DefaultContext context, String sql, int pageNo, int pageSize) throws SQLException {
        return DBTypeUtils.adaptSqlRange(sql, pageNo * pageSize, pageSize, getJdbcurl(context));
    }

    /**
     * @deprecated 请使用 {@link #getJdbcUrl(DefaultContext)}
     */
    public static String getJdbcurl(DefaultContext context) throws SQLException {
        return getJdbcUrl(context);
    }

    /**
     * 通过Yigo的DefaultContext获取jdbc驱动路径
     *
     * @param context
     * @return
     * @throws SQLException
     */
    public static String getJdbcUrl(DefaultContext context) throws SQLException {
        return getConnection(context).getMetaData().getURL();
    }

    /**
     * 通过Yigo的DefaultContext获取连接实例Connection.
     *
     * @param context DefaultContext实例
     * @return
     * @throws SQLException
     */
    public static Connection getConnection(DefaultContext context) throws SQLException {
        try {
            return getConnection(context.getDBManager());
        } catch (Throwable e) {
            throw new SQLException(e);
        }
    }

    /**
     * 通过Yigo的IDBManager获取连接实例Connection.
     *
     * @param dbm IDBManager实例
     * @return
     * @throws SQLException
     */
    public static Connection getConnection(IDBManager dbm) throws SQLException {
        try {
            if ( dbm instanceof IJDBCCompatible ){
                return ((IJDBCCompatible)dbm).getConnection();
            } else if (dbm instanceof GeneralDBManager){
                Connection conn = (Connection)FieldUtils.readField(dbm, "connection", true);
                return conn;
            }else{
                throw new UnsupportedOperationException("Unsupported IDBManager instance: "+dbm.getClass().getName());
            }
        } catch (Throwable e) {
            throw new SQLException(e);
        }
    }
}