package com.bokesoft.distro.tech.yigosupport.extension.utils.codecs;

import java.nio.charset.StandardCharsets;

public class GO9 {

	/**
	 * @param pwd
	 * @return String
	 */

	/* Test code:
     * public static void main(String[] args) {
	       String a = GO9.encryptPWD("English. 中文。", "密钥", 0);
	       DebugUtil.debug(a.equalsIgnoreCase("995A8B5FE427F42095569A4EFA39A87C80432C2E363B2752"));
	   }
     */

    /*
     * Create function in Oracle:
        create or replace
        function GO9Pwd(name varchar2) return varchar2
        as
        language java
        name 'GO9.encryptPWD(java.lang.String) return java.lang.String';
        /
     */

	public static String encryptPWD(String pwd) {
        if (null==pwd){ pwd = ""; }

		String encryptedPWD = encryptPWD(pwd, "Shanghai Boke software,Ltd", 12);
		return encryptedPWD;
	}

	static String hexBytes(byte[] bytes, String blockSplit, int blockByteCount) {
		String sHex = "";
		int idx = 0;
		int j = 0;
		String s;
		int v;
		if (bytes.length > 0) {
			for ( ; idx < bytes.length; ++idx) {
				v = Double.valueOf(bytes[idx]).intValue();
				s = "00" + Integer.toHexString(v);
				s = s.toUpperCase();
				s = s.substring(s.length() - 2);
				sHex += s;
				j = j + 1;
				if (j % blockByteCount == 0) {
					sHex = sHex + blockSplit;
				}
			}
		}
		return sHex;
	}

	// Shanghai Boke software,Ltd
	static private String encryptPWD(String plaintext, String key, int fixLength) {
		return getPWD(plaintext, key, fixLength);
	}
	
	static byte[] BStr2Bytes(String BStr) {
		try {
			byte[] bytes = new byte[0];
			int lLength = BStr.length();
			// byte[] nAscii = null;
			String ansi;
			if (lLength > 0) {
				bytes = new byte[2 * lLength];
				for (int i = 0; i < bytes.length; i++) {
					bytes[i] = 0;
				}
				for (int i = 0; i < lLength; i++) {
					//ansi = new String(BStr.substring(i, i + 1).getBytes(
					//		System.getProperty("sun.jnu.encoding")),
					//		"ISO-8859-1");
					ansi = new String(BStr.substring(i, i + 1).getBytes(StandardCharsets.UTF_8), "ISO-8859-1");
					// nAscii = ASCIIUtility.getBytes(ansi);
					// nAscii = ansi.getBytes();
					if (ansi.length() == 1) {
						// nAscii = new byte[] { (byte) ansi.charAt(0) };
						bytes[2 * i] = (byte) ansi.charAt(0);
					} else if (ansi.length() == 2) {
						// nAscii = new byte[] { (byte) ansi.charAt(0),
						// (byte) ansi.charAt(1) };
						bytes[2 * i] = (byte) ansi.charAt(1);
						bytes[2 * i + 1] = (byte) ansi.charAt(0);
					}
					// if (nAscii.length == 1) {
					// bytes[2 * i] = nAscii[0];
					// } else {
					// bytes[2 * i] = nAscii[1];
					// bytes[2 * i + 1] = nAscii[0];
					// }
				}
			}
			return bytes;
		} catch (Throwable ex) {
            ex.printStackTrace();
			throw new RuntimeException(ex);
		}
	}

	private static String getPWD(String plaintext, String key, int fixLength) {
		String sCryptograph;
		byte[] btsPlntxt;
		byte[] btsKey;
		byte[] plntxt;
		int lLenPlntxt;
		int lLenKey;
		int lLenIdx;
		int j;
		byte btLast;
		plntxt = BStr2Bytes(plaintext);
		btsPlntxt = plntxt;
		if (fixLength > 0) {
			lLenPlntxt = fixLength * 2;
			btsPlntxt = new byte[lLenPlntxt];
			for (int btsIdx = 0; btsIdx < btsPlntxt.length; btsIdx++) {
				if (plntxt != null && plntxt.length > btsIdx) {
					btsPlntxt[btsIdx] = plntxt[btsIdx];
				} else {
					btsPlntxt[btsIdx] = 0;
				}
			}

		} else {
			lLenPlntxt = btsPlntxt.length;
		}
		btsKey = BStr2Bytes(key);
		lLenKey = btsKey.length;
		if (lLenKey == 0) {
			btsKey = new byte[1];
			btsKey[0] = 0;
			lLenKey = 1;
		}
		j = 0;
		btLast = 0;
		for (lLenIdx = 0; lLenIdx < lLenPlntxt; ++lLenIdx) {
			btsPlntxt[lLenIdx] = (byte) (btLast ^ btsPlntxt[lLenIdx] ^ btsKey[j]);
			btLast = btsPlntxt[lLenIdx];
			j = (j + 1) % lLenKey;
		}
		sCryptograph = hexBytes(btsPlntxt, "", 1);
		return sCryptograph;
	}


}