package com.bokesoft.distro.tech.yigosupport.extension.redisdescr.impl.yes;

import com.bokesoft.base.bokebase.rediscache.IDataDescriber;
import com.bokesoft.base.bokebase.rediscache.struct.DescrFormat;
import com.bokesoft.base.bokebase.rediscache.struct.ValueDescription;
import com.bokesoft.yes.mid.session.IAccountLockoutInfo;

public class AccountLockoutCacheDataDescriptor implements IDataDescriber<IAccountLockoutInfo> {
    public static final String CACHEKEY = "AccountLockoutCache";

    @Override
    public ValueDescription describeData(String key, IAccountLockoutInfo accountLockoutInfo) {
        ValueDescription valueDescription = new ValueDescription();
        valueDescription.setDescription(accountLockoutInfo.toString());
        valueDescription.setFormat(DescrFormat.PLAIN);
        return valueDescription;
    }

    @Override
    public String describeKey(String s) {
        return "用户登录失败记录集合";
    }

    @Override
    public String describeHashKey(String k,String hashKey, IAccountLockoutInfo accountLockoutInfo) {
        return "";
    }

}