package com.bokesoft.distro.tech.yigosupport.extension.redisdescr.impl.yee;

import com.bokesoft.base.bokebase.rediscache.IDataDescriber;
import com.bokesoft.base.bokebase.rediscache.struct.DescrFormat;
import com.bokesoft.base.bokebase.rediscache.struct.ValueDescription;
import com.bokesoft.distro.tech.yigosupport.extension.cache.SqlQueryCache;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SqlQueryCacheDataDescriptor implements IDataDescriber<Long> {
    private static final DateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    @Override
    public ValueDescription describeData(String key, Long val) {
        String timeStr = DATETIME_FORMAT.format(new Date(val));
        String desc = "最后缓存时间: "+timeStr+"("+val+")";

        ValueDescription valueDescription = new ValueDescription();
        valueDescription.setDescription(desc);
        valueDescription.setFormat(DescrFormat.PLAIN);
        return valueDescription;
    }

    @Override
    public String describeKey(String s) {
        int prefixLen = (SqlQueryCache.SQL_CACHE_KEY_PREFIX +":").length();
        String cacheName = s.substring(prefixLen);
        return "Sql查询结果缓存("+cacheName+")";
    }

    @Override
    public String describeHashKey(String key, String hashKey, Long val) {
        return "LastQueryTime:${Sql语句}:${参数}: "+hashKey;
    }
}
