package com.bokesoft.distro.tech.yigosupport.extension.redisdescr;

import com.bokesoft.base.bokebase.rediscache.CacheDescription;
import com.bokesoft.base.bokebase.rediscache.ICacheDescriptionProvider;
import com.bokesoft.base.bokebase.rediscache.struct.KeyType;
import com.bokesoft.base.bokebase.rediscache.struct.StoreType;
import com.bokesoft.distro.tech.yigosupport.extension.redisdescr.impl.yes.*;
import com.bokesoft.yes.mid.auth.cache.SessionInfo;
import com.bokesoft.yes.mid.auth.cache.TempSessionInfo;
import com.bokesoft.yes.mid.session.AccountLockoutInfo;
import com.bokesoft.yes.mid.session.IAccountLockoutInfo;
import com.bokesoft.yigo.common.def.LoginMode;
import com.bokesoft.yigo.mid.session.ISessionInfo;

import java.util.Arrays;
import java.util.List;

public class YesRedisDescriptionProvider implements ICacheDescriptionProvider{
    @Override
    public List<CacheDescription<?>> getCacheDescriptions() {
        return Arrays.asList(
            buildYigoSessionCacheDescr(), buildYigoMobileSessionCacheDescr(), buildYigoTempSessionCacheDescr(),
            buildYigoOverTimeSessionCacheDescr(), buildAccountLockoutCacheDescr(), buildYesDictFlagCacheDescr(),
            buildCertCacheDescr()
        );
    }

    /**
     * 构造sessionInfo的缓存描述
     * @return
     */
    private CacheDescription<ISessionInfo> buildYigoSessionCacheDescr(){
        CacheDescription<ISessionInfo> pcSessionCacheDesc = CacheDescription.Builder.
                newBuilder(PCSessionCacheDataDescriptor.CACHEKEY, KeyType.FULL_KEY,
                        "Yigo用户会话", ISessionInfo.class)
                .appendRefClasses(
                        ISessionInfo.class,
                        SessionInfo.class,
                        LoginMode.class)
                .storeType(StoreType.HASH)
                .valueDescriber(new PCSessionCacheDataDescriptor())
                .build();

        return pcSessionCacheDesc;
    }

    /**
     * 构造 moblie相关的 sessionInfo的缓存描述
     * @return
     */
    private CacheDescription<ISessionInfo> buildYigoMobileSessionCacheDescr(){
        CacheDescription<ISessionInfo> pcSessionCacheDesc = CacheDescription.Builder.
                newBuilder(MobileSessionCacheDataDescriptor.CACHEKEY, KeyType.FULL_KEY,
                        "Yigo手持用户会话", ISessionInfo.class)
                .appendRefClasses(
                        ISessionInfo.class,
                        SessionInfo.class,
                        LoginMode.class)
                .storeType(StoreType.HASH)
                .valueDescriber(new MobileSessionCacheDataDescriptor())
                .build();

        return pcSessionCacheDesc;
    }

    /**
     * 构造 临时sessionInfo的缓存描述
     * @return
     */
    private CacheDescription<ISessionInfo> buildYigoTempSessionCacheDescr(){
        CacheDescription<ISessionInfo> pcSessionCacheDesc = CacheDescription.Builder.
                newBuilder(TempSessionCacheDataDescriptor.CACHEKEY, KeyType.FULL_KEY,
                        "临时用户会话", ISessionInfo.class)
                .appendRefClasses(
                        ISessionInfo.class,
                        SessionInfo.class,
                        TempSessionInfo.class,
                        LoginMode.class)
                .storeType(StoreType.HASH)
                .valueDescriber(new TempSessionCacheDataDescriptor())
                .build();

        return pcSessionCacheDesc;
    }

    /**
     * 构造 临时sessionInfo的缓存描述
     * @return
     */
    private CacheDescription<ISessionInfo> buildYigoOverTimeSessionCacheDescr(){
        CacheDescription<ISessionInfo> pcSessionCacheDesc = CacheDescription.Builder.
                newBuilder(OverTimeSessionCacheDataDescriptor.CACHEKEY, KeyType.FULL_KEY,
                        "超时用户会话", ISessionInfo.class)
                .appendRefClasses(
                        ISessionInfo.class,
                        SessionInfo.class,
                        TempSessionInfo.class,
                        LoginMode.class)
                .storeType(StoreType.HASH)
                .valueDescriber(new OverTimeSessionCacheDataDescriptor())
                .build();

        return pcSessionCacheDesc;
    }

    /**
     * 构造用户登录失败记录的缓存描述
     * @return
     */
    private CacheDescription<IAccountLockoutInfo> buildAccountLockoutCacheDescr(){
        CacheDescription<IAccountLockoutInfo> pcSessionCacheDesc = CacheDescription.Builder.
                newBuilder(AccountLockoutCacheDataDescriptor.CACHEKEY , KeyType.FULL_KEY,
                        "用户登录失败记录集合", IAccountLockoutInfo.class)
                .appendRefClasses(
                        IAccountLockoutInfo.class,
                        AccountLockoutInfo.class)
                .storeType(StoreType.HASH)
                .valueDescriber(new AccountLockoutCacheDataDescriptor())
                .build();

        return pcSessionCacheDesc;
    }

    /**
     * 字典结构维护的全局标识的缓存描述
     * @return
     */
    private CacheDescription<Boolean> buildYesDictFlagCacheDescr(){
        CacheDescription<Boolean> pcSessionCacheDesc = CacheDescription.Builder.
                newBuilder(YesDictFlagDataDescriptor.CACHEKEY , KeyType.FULL_KEY,
                        "字典结构维护的全局标识", Boolean.class)
                .storeType(StoreType.HASH)
                .valueDescriber(new YesDictFlagDataDescriptor())
                .build();

        return pcSessionCacheDesc;
    }

    /**
     * 字典结构维护的全局标识的缓存描述
     * @return
     */
    private CacheDescription<String> buildCertCacheDescr(){
        CacheDescription<String> pcSessionCacheDesc = CacheDescription.Builder.
                newBuilder(CertCacheDataDescriptor.CACHEKEY , KeyType.FULL_KEY,
                        "记录密钥的匹配信息", String.class)
                .storeType(StoreType.HASH)
                .valueDescriber(new CertCacheDataDescriptor())
                .build();
        return pcSessionCacheDesc;
    }


}
