package com.bokesoft.distro.tech.yigosupport.extension.exttools.funs;

import com.bokesoft.distro.tech.yigosupport.extension.exttools.sdk.EncryptImpl;
import com.bokesoft.distro.tech.yigosupport.extension.exttools.sdk.EncryptImpl.Configer;
import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * 用于加密解密的公式
 */
public class EncryptExp {
    private static EncryptImpl encryptImpl;

	private static void ensureEncryptImpl(){
		if (null==encryptImpl){
			throw new IllegalStateException(
				"Unconfigured EncryptImpl for EncryptExp, run EncryptExp.Initiator.config(configer) before call EncryptExp.");
		}
	}

	/**
	 * 针对 Yigo 上下文 document 中某个表的某个字段进行加密(默认加密方式)
	 * @param ctx
	 * @param tableName
	 * @param fieldName
	 */
	public static void Encrypt(DefaultContext ctx, String tableName, String fieldName) {
		ensureEncryptImpl();
		encryptImpl.encryptDocument(ctx.getDocument(), tableName, fieldName, EncryptImpl.ENCRYPT_PREFIX_AES);
	}

	/**
	 * 针对 Yigo 上下文 document 中某个表的某个字段进行加密(指定加密方式)
	 * @param ctx
	 * @param tableName
	 * @param fieldName
	 * @param prefix 代表加密方式的前缀, 目前只支持 {@link EncryptImpl#ENCRYPT_PREFIX_AES}
	 */
	public static void Encrypt(DefaultContext ctx, String tableName, String fieldName, String prefix) {
		ensureEncryptImpl();
		encryptImpl.encryptDocument(ctx.getDocument(), tableName, fieldName, prefix);
	}

	/**
	 * 针对 Yigo 上下文 document 中某个表的某个字段进行解密
	 * @param ctx
	 * @param tableName
	 * @param fieldName
	 */
	public static void Decrypt(DefaultContext ctx, String tableName, String fieldName) {
		ensureEncryptImpl();
		encryptImpl.decryptDocument(ctx.getDocument(), tableName, fieldName);
	}
	
	/**
	 * 加密字符串(指定加密方式)
	 * @param value
	 * @param prefix 代表加密方式的前缀, 目前只支持 {@link EncryptImpl#ENCRYPT_PREFIX_AES}
	 * @return
	 */
	public static String EncryptValue(String value, String prefix) {
		ensureEncryptImpl();
		return encryptImpl.encrypt(value, prefix);
	}
	
	/**
	 * 加密字符串(默认加密方式)
	 * @param value
	 * @return
	 */
	public static String EncryptValue(String value) {
		ensureEncryptImpl();
		return encryptImpl.encrypt(value, EncryptImpl.ENCRYPT_PREFIX_AES);
	}

	/**
	 * 解密字符串数据
	 * @param value
	 * @return
	 */
	public static String DecryptValue(String value) {
		ensureEncryptImpl();
		try {
			return encryptImpl.decrypt(value);
		} catch (Exception e) {
			return value;	//无法正常解密, 直接返回原文
		}
	}
	
	/**
	 * 用于将 {@link #config(Configer)} 方法从 {@link EncryptExp} 中独立出来, 避免被识别为公式
	 */
	public static class Initiator {
		/**
		 * 初始化具体加密配置
		 * @param configer
		 */
		public static void config(Configer configer) {
			EncryptExp.encryptImpl = new EncryptImpl(configer);
		}
	}
}
