package com.bokesoft.distro.tech.yigosupport.extension.exception;

import com.bokesoft.yigo.common.exception.CoreException;

/**
 * 用户异常错误，给二次开发人员使用。 
 * 用于二次开发中一些可预期的错误，这些错误抛出时，必须使用该类或者其二开中自定义的CoreException
 * 
 * @author chenzs
 *
 */
public class CustomUserException extends CoreException {

	public static final int BASE_ERROR = 0x0001;

	private static final long serialVersionUID = 20171203L;

	public CustomUserException(int code, String message) {
		super(code, message);
	}

	public CustomUserException(int code, String message,boolean subCode) {
		super(code, message, subCode);
	}

	@Override
	protected int getGroupCode() {
		return 0x8013;
	}

}
