package com.bokesoft.distro.tech.yigosupport.extension.dee.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.dts.data.DTSDataProvider;
import com.bokesoft.yes.dts.types.OperationTypes;

public class DTSUtils {

	public static String opPlan2Str(OperationTypes opPlan) {
		String opName;
		switch (opPlan) {
		case INSERT:
			opName = DTSDataProvider.STRING_INSERT;
			break;
		case UPDATE:
			opName = DTSDataProvider.STRING_UPDATE;
			break;
		case DELETE:
			opName = DTSDataProvider.STRING_DELETE;
			break;
		case I_OR_U:
			opName = DTSDataProvider.STRING_I_OR_U;
			break;
		default:
			opName = DTSDataProvider.STRING_I_OR_U;	//insert-or-update 是默认值
			break;
		}
		return opName;
	}

	public static void configHeader(JSONArray data, String key, Object value) {
		JSONUtils.foreachJSONPath(data, new NodeItr() {
			@Override
			public void process(JSONObject node) {
				node.put(key, value);
			}
		});
	}

	public static void configDetail(String tableName, JSONArray data, String key, Object value) {
		JSONUtils.foreachJSONPath(data, "$."+tableName,  new NodeItr() {
			@Override
			public void process(JSONObject node) {
				node.put(key, value);
			}
		});
	}
}
