package com.bokesoft.distro.tech.yigosupport.extension.base;

import java.util.ArrayList;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.bokesoft.distro.tech.yigosupport.extension.exception.Misc;
import com.bokesoft.distro.tech.yigosupport.extension.impl.WrapperUtils;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IExtService;

/**
 * 通过 {@link IExtService} 第一个调用参数指定调用的静态方法名, 实现一个类处理多个服务调用.
 */
public interface IStaticMethodByNameExtServiceWrapper extends IExtServiceWrapper {
	static final Logger log = LoggerFactory.getLogger(IStaticMethodByNameExtServiceWrapper.class);

	@Override
	default public Object doCmd(DefaultContext ctx, ArrayList<Object> args) throws Throwable {
		try {
			if (null==args || args.size()<=0){
				throw new UnsupportedOperationException("参数列表中至少需要存在一项(需要执行的方法名)");
			}
			String cmd = (String)args.get(0);
			args.remove(0);
			WrapperUtils.findStaticMethod(ctx, this.getClass(), args.toArray(), cmd);
			Object result = WrapperUtils.tryRunStaticMethod(ctx, this.getClass(), cmd, args.toArray());
			return result;
		}catch(Exception ex) {
			throw Misc.convertToYigoException(ex, log);
		}
	}

}
