package com.bokesoft.distro.tech.yigosupport.extension.auth;

import com.bokesoft.distro.tech.commons.basis.auth.CrossAuthUtil;
import com.bokesoft.yigo.mid.para.SysPara;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;

/**
 * 用于应用间访问的授权验证(CrossAuth)
 */
public class CrossAuthHelper {

    private static Logger logger = LoggerFactory.getLogger(CrossAuthHelper.class);

    /**
     * 直接根据 {@link HttpServletRequest} 实例获取验证加密信息,并解密以及验证身份信息是否有效.
     * <p>
     *     说明: 加密信息字符串以 HTTP Header 或 Parameter的方式传递, Header Name、Parameter Name
     *     均为 {@link CrossAuthUtil#AUTH_WILDCARD}
     * </p>
     * @param request {@link HttpServletRequest}请求对象
     * @return
     */
    public static boolean doAuth(HttpServletRequest request) {
        String authStr = getTokenString(request);
        return doAuth(authStr);
    }

    private static boolean doAuth(String authStr) {
        try {
            return CrossAuthUtil.doCheck(SysPara.getInstance().get("PrivateKey"), authStr);
        }catch (Exception e){
            logger.error("无法解析Auth加密信息",e);
            return false;
        }
    }

    private static String getTokenString(HttpServletRequest request){
        // 从request-header获取auth token信息,有则直接返回
        String tokenStr = request.getHeader(CrossAuthUtil.AUTH_WILDCARD);
        if(StringUtils.isNotBlank(tokenStr)) {
            return tokenStr;
        }
        // 从request-param 获取auth token信息,有则直接返回
        return request.getParameter(CrossAuthUtil.AUTH_WILDCARD);
    }

}
