package com.bokesoft.distro.tech.yigosupport.extension;

import java.util.ServiceLoader;

import com.bokesoft.distro.tech.yigosupport.extension.intf.IExtServiceWrapperService;
import com.bokesoft.distro.tech.yigosupport.extension.intf.IFunctionProviderService;
import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.ServiceLoaderRegisteringUtil;
import com.bokesoft.yes.base.IStartListener;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IUpdateListener;

/**
 * 用于初始化 Yigo 的 {@link IExtServiceWrapperService} 和 {@link IFunctionProviderService};
 * 要求符合 Java {@link ServiceLoader} 机制的条件, 在 META-INF/services 目录下创建相应接口的文件并记录需要加载的实现类。
 * <br/>
 * 在 Yigo 2.0 中使用时, 需要手工在 solution 的 `Enhance.xml` 中注册，例如:
 * <pre>
 * &lt;ExtStartListener&gt;
 *     &lt;StartListener Impl="com.bokesoft.distro.tech.yigosupport.extension.ServiceLoaderRegisteringStartListener"
 *                    Description="自动加载通过 ServiceLoader 管理的中间层扩展"/&gt;
 * &lt;/ExtStartListener&gt;
 * </pre>
 * 在支持 HotDeploy 的环境中, 还需要注册 IUpdateListener:
 * <pre>
 * &lt;ExtUpdateListener&gt;
 *     &lt;UpdateListener Impl="com.bokesoft.distro.tech.yigosupport.extension.ServiceLoaderRegisteringStartListener"
 *                    Description="自动加载通过 ServiceLoader 管理的中间层扩展"/&gt;
 * &lt;/ExtUpdateListener&gt;
 * </pre>
 * @deprecated 4.0.6 之后 boot-support 默认会使用相同的逻辑进行初始化, 不需要显式在 `Enhance.xml` 中注册
 * FIXME 因为 Yigo3.1 使用了2.2.5的泛型, 导致目前只能使用 com.bokesoft.yes.base 下的 IStartListener 才能有效注册
 */
@Deprecated
public class ServiceLoaderRegisteringStartListener implements IStartListener, IUpdateListener{
	@Override
	public void invoke(DefaultContext ctx) throws Throwable {
		ServiceLoaderRegisteringUtil.invoke(ctx);
	}
}
