/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.deployment.resource;

import com.bokesoft.distro.tech.yigosupport.deployment.resource.ResourceMultiSolutionResolver;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.intf.IResourceIO;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceMultiSolutionMetaResolverFactory
implements IMetaResolverFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractResourceMultiSolutionMetaResolverFactory.class);
    private static final char SEPARATOR = "/".charAt(0);
    private IResourceIO resourceIO;
    private List<String> resources;
    private String instanceId;

    protected abstract IResourceIO getResourceIO();

    public void initParas(Map<String, Object> paras) {
        try {
            this.resourceIO = this.getResourceIO();
            this.resources = this.resourceIO.list();
            this.instanceId = this.resourceIO.getInstanceId();
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public String getSolutionPath() {
        String slnPath = null;
        try {
            IMetaResolver resolver = this.newMetaResolver("");
            String slnXml = resolver.getPath("Solution.xml");
            File fSlnXml = new File(slnXml);
            if (fSlnXml.exists()) {
                slnPath = fSlnXml.getParentFile().getCanonicalPath();
                log.info("[{}]: Solution.xml \u662f\u6709\u6548\u6587\u4ef6, \u5df2\u83b7\u53d6\u6709\u6548\u7684 Solution Path '{}'", (Object)this.instanceId, (Object)slnPath);
            } else {
                slnPath = null;
                log.warn("[{}]: \u6587\u4ef6 {} \u4e0d\u5b58\u5728, \u65e0\u6cd5\u83b7\u53d6\u6709\u6548\u7684 Solution Path", (Object)this.instanceId, (Object)fSlnXml);
            }
        }
        catch (Exception ex) {
            log.warn("[{}]: \u83b7\u53d6 Solution Path \u51fa\u9519: {}.", (Object)this.instanceId, (Object)ex.getMessage());
            if (log.isDebugEnabled()) {
                log.debug("[" + this.instanceId + "] \u8be6\u7ec6\u9519\u8bef\u4fe1\u606f: " + ex.getMessage(), (Throwable)ex);
            }
            slnPath = null;
        }
        if (null != slnPath) {
            return slnPath;
        }
        try {
            String safeName = FilenameUtils.normalize((String)(null == this.instanceId ? "" : this.instanceId)).replaceAll("[\\\\/:*?\"<>|]", "_");
            Path path = Files.createTempDirectory(this.getClass().getSimpleName() + "-" + DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(System.currentTimeMillis()) + "." + safeName + ".", new FileAttribute[0]);
            File tmpDir = path.toFile();
            FileUtils.forceMkdir((File)tmpDir);
            String tmp = tmpDir.getCanonicalPath();
            log.warn("[{}]: \u4e0d\u5efa\u8bae\u4f7f\u7528\u7684 API \u8c03\u7528 - getSolutionPath, \u8fd4\u56de\u65e0\u6548\u503c '{}'", (Object)this.instanceId, (Object)tmp);
            return tmp;
        }
        catch (IOException e) {
            return (String)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public IMetaResolver newMetaResolver(String prefix) {
        ResourceMultiSolutionResolver resolver = new ResourceMultiSolutionResolver(this.resources, this.resourceIO, prefix);
        log.info("create newMetaResolver [{}]: prefix='{}' .", (Object)this.instanceId, (Object)prefix);
        return resolver;
    }

    public IMetaResolver newFileMetaResolver(String prefix) {
        throw new UnsupportedOperationException("New IMetaResolver with absolute identifier is not supported(instance='" + this.instanceId + "', prefix='" + prefix + "')");
    }

    public char getSeparator() {
        return SEPARATOR;
    }
}

