/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.io.internal;

import com.bokesoft.distro.tech.commons.basis.io.internal.TempWriterManager;
import com.bokesoft.distro.tech.commons.basis.io.internal.WriterParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileTempWriter<T> {
    private static final Logger log = LoggerFactory.getLogger(LocalFileTempWriter.class);
    private Class<?> clazz;
    private String tmpDir;
    private String readyDir;
    private String errDir;
    private String fileName;
    private long blockTime;
    private long createTime;
    private ObjectOutputStream oos;

    public String getFileName() {
        return this.fileName;
    }

    public long getBlockTime() {
        return this.blockTime;
    }

    public LocalFileTempWriter(String fileName, Class<T> clazz, WriterParam param) {
        try {
            this.clazz = clazz;
            this.tmpDir = param.getTmpDir();
            this.readyDir = param.getReadyDir();
            this.errDir = param.getErrDir();
            this.blockTime = param.getBlockTime();
            this.fileName = fileName;
            this.createTime = System.currentTimeMillis();
            File file = new File(this.tmpDir, fileName);
            this.oos = new ObjectOutputStream(new FileOutputStream(file));
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(T value) throws IOException {
        ObjectOutputStream objectOutputStream = this.oos;
        synchronized (objectOutputStream) {
            this.oos.writeObject(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryFlush() throws IOException {
        if (System.currentTimeMillis() > this.createTime + this.blockTime * 2L) {
            ObjectOutputStream objectOutputStream = this.oos;
            synchronized (objectOutputStream) {
                this.oos.flush();
                this.oos.close();
            }
            TempWriterManager.WRITERS_CACHE.remove(this.fileName);
            if (log.isDebugEnabled()) {
                log.debug("LocalFileTempStorage \u6587\u4ef6 {} \u5df2\u5199\u5165\u5b8c\u6bd5,\u53ef\u4ee5\u8fc1\u79fb.", (Object)this.fileName);
            }
        }
    }
}

