/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.flightrecord.struc.rediscache;

import com.bokesoft.base.bokebase.rediscache.CacheDescription;
import com.bokesoft.base.bokebase.rediscache.struct.DataType;
import com.bokesoft.base.bokebase.rediscache.struct.KeyType;
import com.bokesoft.base.bokebase.rediscache.struct.StoreType;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.rediscache.ClassInfo;
import com.bokesoft.distro.tech.commons.basis.flightrecord.utils.YFRUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class CacheDescriptionDTO
implements Externalizable {
    private String key;
    private KeyType keyType;
    private String description;
    private StoreType storeType;
    private List<ClassInfo> refClasses;
    private byte[] valueDescriberBytes;
    private DataType dataType;

    public static CacheDescriptionDTO toDTO(CacheDescription cacheDescription) {
        CacheDescriptionDTO cacheDescriptionDTO = new CacheDescriptionDTO();
        cacheDescriptionDTO.setKey(cacheDescription.getKey());
        cacheDescriptionDTO.setDescription(cacheDescription.getDescription());
        cacheDescriptionDTO.setKeyType(cacheDescription.getKeyType());
        cacheDescriptionDTO.setStoreType(cacheDescription.getStoreType());
        cacheDescriptionDTO.setDataType(cacheDescription.getDataType());
        ArrayList refClasses = new ArrayList();
        if (cacheDescription.getValueDescriber() != null) {
            refClasses.add(cacheDescription.getValueDescriber().getClass());
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            try {
                new ObjectOutputStream(buf).writeObject(cacheDescription.getValueDescriber());
            }
            catch (IOException e) {
                return (CacheDescriptionDTO)ExceptionUtils.rethrow((Throwable)e);
            }
            cacheDescriptionDTO.setValueDescriberBytes(buf.toByteArray());
        }
        if (cacheDescription.getRefClasses() != null) {
            refClasses.addAll(cacheDescription.getRefClasses());
        }
        cacheDescriptionDTO.setRefClasses(refClasses.stream().distinct().map(c -> {
            if (YFRUtils.isJREClass(c)) {
                return null;
            }
            return new ClassInfo(c.getName(), YFRUtils.getClassBytes(c));
        }).filter(Objects::nonNull).sorted(Comparator.comparing(ClassInfo::getClassName)).collect(Collectors.toList()));
        return cacheDescriptionDTO;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.key) ? 1 : 0) != 0);
        Preconditions.checkArgument((this.keyType != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.description) ? 1 : 0) != 0);
        out.writeUTF(this.key);
        out.writeObject(this.keyType);
        out.writeUTF(this.description);
        out.writeObject(this.storeType);
        if (this.refClasses != null) {
            out.writeInt(this.refClasses.size());
            this.refClasses.stream().sorted(Comparator.comparing(ClassInfo::getClassName)).forEach(ci -> {
                try {
                    out.writeObject(ci);
                }
                catch (IOException e) {
                    ExceptionUtils.rethrow((Throwable)e);
                }
            });
        } else {
            out.writeInt(0);
        }
        if (this.valueDescriberBytes != null) {
            out.writeInt(this.valueDescriberBytes.length);
            out.write(this.valueDescriberBytes);
        } else {
            out.writeInt(0);
        }
        out.writeObject(this.dataType);
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.key = in.readUTF();
        this.keyType = (KeyType)in.readObject();
        this.description = in.readUTF();
        this.storeType = (StoreType)in.readObject();
        this.refClasses = new ArrayList<ClassInfo>();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            this.refClasses.add((ClassInfo)in.readObject());
        }
        this.valueDescriberBytes = new byte[in.readInt()];
        in.readFully(this.valueDescriberBytes);
        this.dataType = (DataType)in.readObject();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public void setKeyType(KeyType keyType) {
        this.keyType = keyType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public StoreType getStoreType() {
        return this.storeType;
    }

    public void setStoreType(StoreType storeType) {
        this.storeType = storeType;
    }

    public List<ClassInfo> getRefClasses() {
        return this.refClasses;
    }

    public void setRefClasses(List<ClassInfo> refClasses) {
        this.refClasses = refClasses;
    }

    public byte[] getValueDescriberBytes() {
        return this.valueDescriberBytes;
    }

    public void setValueDescriberBytes(byte[] valueDescriberBytes) {
        this.valueDescriberBytes = valueDescriberBytes;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public String toString() {
        return "CacheDescriptionDTO{key='" + this.key + '\'' + ", keyType=" + this.keyType + ", description='" + this.description + '\'' + ", storeType=" + this.storeType + ", refClasses=" + this.refClasses + ", dataType=" + this.dataType + '}';
    }
}

