/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.flightrecord.impl;

import com.bokesoft.distro.tech.commons.basis.flightrecord.intf.IDataSourceCfgResolver;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.database.DatasourceCfgVO;
import com.bokesoft.distro.tech.commons.basis.flightrecord.utils.YFRUtils;
import javax.sql.DataSource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class DefaultDataSourceCfgResolver
implements IDataSourceCfgResolver {
    @Override
    public DatasourceCfgVO build(DataSource dataSource) {
        String datasourceClass = dataSource.getClass().getName();
        try {
            if ("org.apache.commons.dbcp.BasicDataSource".equals(datasourceClass)) {
                DatasourceCfgVO result = this.buildDatasourceCfgEventByDBCP(dataSource);
                return result;
            }
            if ("com.zaxxer.hikari.HikariDataSource".equals(datasourceClass)) {
                DatasourceCfgVO result = this.buildDatasourceCfgEventByHikraiCP(dataSource);
                return result;
            }
            if ("com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceWrapper".equals(datasourceClass)) {
                DatasourceCfgVO result = this.buildDatasourceCfgEventByDruid(dataSource);
                return result;
            }
        }
        catch (ReflectiveOperationException e) {
            return (DatasourceCfgVO)ExceptionUtils.rethrow((Throwable)e);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684 DataSource \u7c7b\u578b: " + datasourceClass);
    }

    private DatasourceCfgVO buildDatasourceCfgEventByDBCP(DataSource dataSource) throws ReflectiveOperationException {
        String datasourceId = YFRUtils.getDatasourceId(dataSource);
        String jdbcUrl = (String)MethodUtils.invokeMethod((Object)dataSource, (String)"getUrl");
        String driverClassName = (String)MethodUtils.invokeMethod((Object)dataSource, (String)"getDriverClassName");
        int initialSize = (Integer)MethodUtils.invokeMethod((Object)dataSource, (String)"getInitialSize");
        int minIdle = (Integer)MethodUtils.invokeMethod((Object)dataSource, (String)"getMinIdle");
        int maxIdle = (Integer)MethodUtils.invokeMethod((Object)dataSource, (String)"getMaxIdle");
        long maxActive = ((Integer)MethodUtils.invokeMethod((Object)dataSource, (String)"getMaxActive")).intValue();
        return new DatasourceCfgVO(datasourceId, jdbcUrl, driverClassName, initialSize, minIdle, maxIdle, maxActive);
    }

    private DatasourceCfgVO buildDatasourceCfgEventByDruid(DataSource dataSource) throws ReflectiveOperationException {
        String datasourceId = YFRUtils.getDatasourceId(dataSource);
        String jdbcUrl = (String)MethodUtils.invokeMethod((Object)dataSource, (String)"getRawJdbcUrl");
        String driverClassName = (String)MethodUtils.invokeMethod((Object)dataSource, (String)"getDriverClassName");
        int initialSize = (Integer)MethodUtils.invokeMethod((Object)dataSource, (String)"getInitialSize");
        int minIdle = (Integer)MethodUtils.invokeMethod((Object)dataSource, (String)"getMinIdle");
        int maxIdle = (Integer)MethodUtils.invokeMethod((Object)dataSource, (String)"getMaxIdle");
        long maxActive = ((Integer)MethodUtils.invokeMethod((Object)dataSource, (String)"getMaxActive")).intValue();
        return new DatasourceCfgVO(datasourceId, jdbcUrl, driverClassName, initialSize, minIdle, maxIdle, maxActive);
    }

    private DatasourceCfgVO buildDatasourceCfgEventByHikraiCP(DataSource dataSource) throws ReflectiveOperationException {
        int initialSize;
        String datasourceId = YFRUtils.getDatasourceId(dataSource);
        String jdbcUrl = (String)MethodUtils.invokeMethod((Object)dataSource, (String)"getJdbcUrl");
        String driverClassName = (String)MethodUtils.invokeMethod((Object)dataSource, (String)"getDriverClassName");
        int minIdle = initialSize = ((Integer)MethodUtils.invokeMethod((Object)dataSource, (String)"getMinimumIdle")).intValue();
        int maxIdle = (Integer)MethodUtils.invokeMethod((Object)dataSource, (String)"getMaximumPoolSize");
        long maxActive = (Long)MethodUtils.invokeMethod((Object)dataSource, (String)"getMaxLifetime");
        return new DatasourceCfgVO(datasourceId, jdbcUrl, driverClassName, initialSize, minIdle, maxIdle, maxActive);
    }
}

