/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.coordinate;

import com.bokesoft.distro.tech.commons.basis.coordinate.impl.SimpleSemaphoreChannel;
import com.bokesoft.distro.tech.commons.basis.coordinate.impl.SimpleSemaphoreThrottle;
import com.bokesoft.distro.tech.commons.basis.coordinate.intf.ISemaphoreChannel;
import com.bokesoft.distro.tech.commons.basis.coordinate.intf.ISemaphoreChannelFactory;
import com.bokesoft.distro.tech.commons.basis.coordinate.intf.ISemaphoreConsumer;
import com.bokesoft.distro.tech.commons.basis.coordinate.struct.Semaphore;
import com.bokesoft.distro.tech.commons.basis.coordinate.struct.ThrottleConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemaphoreEventBus {
    private static SemaphoreEventBus INSTANCE;
    private static ISemaphoreChannelFactory factory;
    private final ISemaphoreChannel channel;
    private static final Logger log;
    private ThrottleConfig sendThrottle;
    private ThrottleConfig receiveThrottle;
    private final Map<String, Sender> senderMap = new HashMap<String, Sender>();
    private final Map<String, Receiver> receiverMap = new HashMap<String, Receiver>();

    public static void setFactory(ISemaphoreChannelFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        SemaphoreEventBus.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SemaphoreEventBus getINSTANCE() {
        if (INSTANCE != null) return INSTANCE;
        Class<SemaphoreEventBus> clazz = SemaphoreEventBus.class;
        synchronized (SemaphoreEventBus.class) {
            if (INSTANCE != null) return INSTANCE;
            try {
                INSTANCE = new SemaphoreEventBus(factory);
            }
            catch (Exception e) {
                log.error("SemaphoreEventBus \u521d\u59cb\u5316\u5931\u8d25,\u4f7f\u7528\u9ed8\u8ba4\u672c\u5730\u5b9e\u73b0!", (Throwable)e);
                // ** MonitorExit[var0] (shouldn't be in output)
                return (SemaphoreEventBus)ExceptionUtils.rethrow((Throwable)e);
            }
            return INSTANCE;
        }
    }

    public SemaphoreEventBus(ISemaphoreChannelFactory factory) throws Exception {
        this.channel = factory.createChannel(this);
    }

    public final void registerSender(String semaphoreKey, ThrottleConfig config) {
        this.senderMap.put(semaphoreKey, new Sender(semaphoreKey, config == null ? this.sendThrottle : config));
    }

    public Sender getSender(String semaphoreKey) {
        return this.senderMap.get(semaphoreKey);
    }

    public boolean canSend(String semaphoreKey) {
        return this.senderMap.containsKey(semaphoreKey);
    }

    public final void registerReceiver(String semaphoreKey, ISemaphoreConsumer consumer, ThrottleConfig config) {
        Receiver receiver = new Receiver(semaphoreKey, consumer, config == null ? this.receiveThrottle : config);
        this.receiverMap.put(semaphoreKey, receiver);
    }

    public final Receiver getReceiver(String semaphoreKey) {
        return this.receiverMap.get(semaphoreKey);
    }

    public ThrottleConfig getSendThrottle() {
        return this.sendThrottle;
    }

    public void setSendThrottle(ThrottleConfig sendThrottle) {
        this.sendThrottle = sendThrottle;
    }

    public ThrottleConfig getReceiveThrottle() {
        return this.receiveThrottle;
    }

    public void setReceiveThrottle(ThrottleConfig receiveThrottle) {
        this.receiveThrottle = receiveThrottle;
    }

    public void postSend(Semaphore semaphore) {
        Sender sender = this.getSender(semaphore.key);
        if (sender != null) {
            sender.doSend(semaphore);
        }
    }

    public void postSend(String semaphore) {
        this.postSend(new Semaphore(semaphore));
    }

    public void onReceiver(Semaphore semaphore) {
        Receiver receiver = this.getReceiver(semaphore.key);
        if (receiver != null) {
            receiver.onSemaphore(semaphore);
        }
    }

    static {
        factory = eventBus -> new SimpleSemaphoreChannel(eventBus);
        log = LoggerFactory.getLogger(SemaphoreEventBus.class);
    }

    private final class Sender {
        public final String key;
        private final ThrottleConfig config;
        private final SimpleSemaphoreThrottle throttle;

        public Sender(String key, ThrottleConfig config) {
            this.key = key;
            this.config = config;
            this.throttle = config == null ? null : new SimpleSemaphoreThrottle(config);
        }

        public void doSend(Semaphore semaphore) {
            if (this.throttle != null) {
                this.throttle.onFilter(semaphore, SemaphoreEventBus.this.channel::doSend);
            } else {
                SemaphoreEventBus.this.channel.doSend(semaphore);
            }
        }
    }

    private class Receiver {
        public final String key;
        public final Consumer<Semaphore> consumer;
        private final ThrottleConfig config;
        private final SimpleSemaphoreThrottle throttle;

        public Receiver(String key, Consumer<Semaphore> consumer, ThrottleConfig config) {
            this.key = key;
            this.consumer = consumer;
            this.config = config;
            this.throttle = config == null ? null : new SimpleSemaphoreThrottle(config);
        }

        public void onSemaphore(Semaphore semaphore) {
            if (this.throttle != null) {
                this.throttle.onFilter(semaphore, this.consumer);
            } else {
                this.consumer.accept(semaphore);
            }
        }
    }
}

