/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTemplate {
    public static final String REGEX_PATTERN_JAVA_STYLE = "\\$\\{([^\\}]*)\\}";
    public static final String REGEX_PATTERN_UNIX_SHELL_STYLE = "\\$([a-zA-Z_]+)";
    private Map<String, String> varExpMap = new LinkedHashMap<String, String>();
    private Map<String, String> varValueMap = new HashMap<String, String>();
    private List<String> varExpList = new ArrayList<String>();
    private String templateString;

    public StringTemplate(String templateString, String templateRegex) {
        Pattern p = Pattern.compile(templateRegex);
        Matcher m = p.matcher(templateString);
        while (m.find()) {
            if (m.groupCount() == 1) {
                this.varExpMap.put(m.group(1), m.group(0));
                this.varExpList.add(m.group(1));
                continue;
            }
            throw new RuntimeException("Pattern '" + templateRegex + "' is not valid, it must contain and only contain one regex group.");
        }
        this.templateString = templateString;
    }

    public String[] getVariables() {
        Set<String> strings = this.varExpMap.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    public String[] getVariablesInOrder() {
        return this.varExpList.toArray(new String[this.varExpList.size()]);
    }

    public void setVariable(String varName, String varValue) {
        this.varValueMap.put(varName, varValue);
    }

    public String getParseResult() {
        Iterator<Map.Entry<String, String>> itr = this.varExpMap.entrySet().iterator();
        String tmp = this.templateString;
        while (itr.hasNext()) {
            Map.Entry<String, String> en = itr.next();
            String varName = en.getKey();
            String varExp = en.getValue();
            String val = this.varValueMap.get(varName);
            if (null == val) continue;
            tmp = tmp.replace(varExp, val);
        }
        return tmp;
    }

    public void reset() {
        this.varValueMap.clear();
    }
}

