/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtil {
    private static Logger logger = LoggerFactory.getLogger(NetworkUtil.class);
    private static String cachedHostName;
    private static long hostNameLoadTime;
    private static String cachedIPv4;
    private static long ipv4LoadTime;
    private static String cachedMacAddress;
    private static long macAddressLoadTime;
    private static final long INTERVAL_TIME = 28800000L;
    private static final byte[][] invalidMacs;

    public static String getHost() {
        long curTime = System.currentTimeMillis();
        if (StringUtils.isNotBlank((CharSequence)cachedHostName) && curTime < hostNameLoadTime) {
            return cachedHostName;
        }
        cachedHostName = System.getenv("BK_INSTANCE_HOSTNAME");
        if (StringUtils.isBlank((CharSequence)cachedHostName)) {
            cachedHostName = System.getenv("HOSTNAME");
        }
        if (StringUtils.isBlank((CharSequence)cachedHostName)) {
            try {
                cachedHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.error("\u67e5\u627e\u7f51\u7edc\u4e3b\u673a\u540d\u79f0\u9519\u8bef: " + e.getMessage(), (Throwable)e);
                cachedHostName = "unknown";
            }
        }
        if (StringUtils.isBlank((CharSequence)cachedHostName)) {
            cachedHostName = "unknown";
        }
        hostNameLoadTime = System.currentTimeMillis() + 28800000L;
        return cachedHostName;
    }

    public static String getIp() {
        long curTime = System.currentTimeMillis();
        if (StringUtils.isNotBlank((CharSequence)cachedIPv4) && curTime < ipv4LoadTime) {
            return cachedIPv4;
        }
        cachedIPv4 = NetworkUtil.getRealIp();
        if (StringUtils.isNotBlank((CharSequence)cachedIPv4)) {
            ipv4LoadTime = System.currentTimeMillis() + 28800000L;
        }
        return cachedIPv4;
    }

    public static String getMacAddress() {
        long curTime = System.currentTimeMillis();
        if (StringUtils.isNotBlank((CharSequence)cachedMacAddress) && curTime < macAddressLoadTime) {
            return cachedMacAddress;
        }
        cachedMacAddress = NetworkUtil.getRealMacAddress();
        if (StringUtils.isNotBlank((CharSequence)cachedMacAddress)) {
            macAddressLoadTime = System.currentTimeMillis() + 28800000L;
        }
        return cachedMacAddress;
    }

    private static String getRealIp() {
        String vmMacNetIP = "";
        String virtualNetIP = "";
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (NetworkUtil.isPhyicalOnlyNet(networkInterface)) {
                    String phyicalIP = NetworkUtil.formatIPv4(networkInterface.getInetAddresses());
                    if (!StringUtils.isNotBlank((CharSequence)phyicalIP)) continue;
                    logger.debug("\u53d1\u73b0\u7269\u7406\u7f51\u5361 {}, \u8fd4\u56de IPv4 \u5730\u5740 {} \u4f5c\u4e3a\u9ed8\u8ba4\u7684\u5e94\u7528\u5b9e\u4f8b ID", (Object)networkInterface.toString(), (Object)phyicalIP);
                    return phyicalIP;
                }
                if (NetworkUtil.isVMMacNet(networkInterface)) {
                    if (!StringUtils.isBlank((CharSequence)vmMacNetIP)) continue;
                    vmMacNetIP = NetworkUtil.formatIPv4(networkInterface.getInetAddresses());
                    logger.debug("\u53d1\u73b0 VM \u7f51\u5361 {}, IPv4 \u5730\u5740\u4e3a {}", (Object)networkInterface.toString(), (Object)vmMacNetIP);
                    continue;
                }
                if (!NetworkUtil.isVirtualNet(networkInterface) || !StringUtils.isBlank((CharSequence)virtualNetIP)) continue;
                virtualNetIP = NetworkUtil.formatIPv4(networkInterface.getInetAddresses());
                logger.debug("\u53d1\u73b0\u865a\u62df\u7f51\u5361 {}, IPv4 \u5730\u5740\u4e3a {}", (Object)networkInterface.toString(), (Object)vmMacNetIP);
            }
            if (StringUtils.isNotBlank((CharSequence)vmMacNetIP)) {
                logger.debug("\u8fd4\u56de VM \u7f51\u5361 IPv4 \u5730\u5740\u4e3a {} \u4f5c\u4e3a\u9ed8\u8ba4\u7684\u5e94\u7528\u5b9e\u4f8b ID", (Object)vmMacNetIP);
                return vmMacNetIP;
            }
            if (StringUtils.isNotBlank((CharSequence)virtualNetIP)) {
                logger.debug("\u8fd4\u56de\u865a\u62df\u7f51\u5361 IPv4 \u5730\u5740\u4e3a {} \u4f5c\u4e3a\u9ed8\u8ba4\u7684\u5e94\u7528\u5b9e\u4f8b ID", (Object)virtualNetIP);
                return virtualNetIP;
            }
        }
        catch (Exception e) {
            logger.error("\u7f51\u5361\u904d\u5386\u8fc7\u7a0b\u51fa\u9519: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static String getRealMacAddress() {
        String vmMacNet = "";
        String virtualNet = "";
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (NetworkUtil.isPhyicalOnlyNet(networkInterface)) {
                    String mac = NetworkUtil.format(networkInterface.getHardwareAddress());
                    logger.debug("\u53d1\u73b0\u7269\u7406\u7f51\u5361 {}, \u8fd4\u56de MAC \u5730\u5740 {} \u4f5c\u4e3a\u9ed8\u8ba4\u7684\u5e94\u7528\u5b9e\u4f8b ID", (Object)networkInterface.toString(), (Object)mac);
                    return mac;
                }
                if (NetworkUtil.isVMMacNet(networkInterface)) {
                    if (!StringUtils.isBlank((CharSequence)vmMacNet)) continue;
                    vmMacNet = NetworkUtil.format(networkInterface.getHardwareAddress());
                    logger.debug("\u53d1\u73b0 VM \u7f51\u5361 {}, MAC \u5730\u5740\u4e3a {}", (Object)networkInterface.toString(), (Object)vmMacNet);
                    continue;
                }
                if (!NetworkUtil.isVirtualNet(networkInterface) || !StringUtils.isBlank((CharSequence)virtualNet)) continue;
                virtualNet = NetworkUtil.format(networkInterface.getHardwareAddress());
                logger.debug("\u53d1\u73b0\u865a\u62df\u7f51\u5361 {}, MAC \u5730\u5740\u4e3a {}", (Object)networkInterface.toString(), (Object)virtualNet);
            }
            if (StringUtils.isNotBlank((CharSequence)vmMacNet)) {
                logger.debug("\u8fd4\u56de VM \u7f51\u5361 MAC \u5730\u5740\u4e3a {} \u4f5c\u4e3a\u9ed8\u8ba4\u7684\u5e94\u7528\u5b9e\u4f8b ID", (Object)vmMacNet);
                return vmMacNet;
            }
            if (StringUtils.isNotBlank((CharSequence)virtualNet)) {
                logger.debug("\u8fd4\u56de\u865a\u62df\u7f51\u5361 MAC \u5730\u5740\u4e3a {} \u4f5c\u4e3a\u9ed8\u8ba4\u7684\u5e94\u7528\u5b9e\u4f8b ID", (Object)virtualNet);
                return virtualNet;
            }
        }
        catch (Exception e) {
            logger.error("\u7f51\u5361\u904d\u5386\u8fc7\u7a0b\u51fa\u9519: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static boolean isVirtualNet(NetworkInterface input) {
        return input.isVirtual();
    }

    private static boolean isPhyicalOnlyNet(NetworkInterface input) throws SocketException {
        byte[] hardwareAddress = input.getHardwareAddress();
        return null != hardwareAddress && hardwareAddress.length > 0 && !input.isVirtual() && !NetworkUtil.isVMMac(hardwareAddress);
    }

    private static boolean isVMMacNet(NetworkInterface input) throws SocketException {
        byte[] hardwareAddress = input.getHardwareAddress();
        return null != hardwareAddress && hardwareAddress.length > 0 && !input.isVirtual() && NetworkUtil.isVMMac(hardwareAddress);
    }

    private static boolean isVMMac(byte[] mac) {
        if (null == mac) {
            return false;
        }
        for (byte[] invalid : invalidMacs) {
            if (invalid[0] != mac[0] || invalid[1] != mac[1] || invalid[2] != mac[2]) continue;
            return true;
        }
        return false;
    }

    public static String format(byte[] source) {
        if (null == source) {
            return "";
        }
        ArrayList<String> hex = new ArrayList<String>(source.length);
        for (byte input : source) {
            hex.add(String.copyValueOf(new char[]{Character.forDigit((input & 0xF0) >> 4, 16), Character.forDigit(input & 0xF, 16)}));
        }
        return StringUtils.join(hex, (String)"-");
    }

    private static String formatIPv4(Enumeration<InetAddress> inetAddressEnumeration) {
        while (inetAddressEnumeration.hasMoreElements()) {
            InetAddress inetAddress = inetAddressEnumeration.nextElement();
            if (null == inetAddress || !(inetAddress instanceof Inet4Address)) continue;
            return inetAddress.getHostAddress();
        }
        return null;
    }

    static {
        hostNameLoadTime = 0L;
        ipv4LoadTime = 0L;
        macAddressLoadTime = 0L;
        invalidMacs = new byte[][]{{0, 5, 105}, {0, 28, 20}, {0, 12, 41}, {0, 80, 86}, {8, 0, 39}, {10, 0, 39}, {0, 3, -1}, {0, 21, 93}};
    }
}

