/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.jdbc;

import com.bokesoft.distro.tech.commons.basis.StringTemplate;
import com.bokesoft.distro.tech.commons.basis.jdbc.JDBCConverter;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLTools {
    private static final Logger logger = LoggerFactory.getLogger(SQLTools.class);

    private SQLTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransSqlResult transferSql(Connection conn, String sql, ValueExtractor values) throws SQLException {
        Statement pstmt = null;
        try {
            StringTemplate st = new StringTemplate(sql, "\\$\\{([^\\}]*)\\}");
            String[] vars = st.getVariables();
            String[] varList = st.getVariablesInOrder();
            int nonSqlParamsCount = 0;
            for (String var : vars) {
                if (var.startsWith("#")) {
                    ++nonSqlParamsCount;
                    Object obj = values.get(var);
                    if (null == obj) continue;
                    st.setVariable(var, obj.toString());
                    continue;
                }
                st.setVariable(var, "?");
            }
            String pSql = st.getParseResult();
            pstmt = conn.prepareStatement(pSql = pSql.trim());
            ParameterMetaData pMeta = pstmt.getParameterMetaData();
            if (pMeta.getParameterCount() != varList.length - nonSqlParamsCount) {
                throw new SQLException("SQL \u8bed\u53e5 [" + sql + "] \u65e0\u6cd5\u6b63\u786e\u89e3\u6790\u53c2\u6570 [" + pSql + "]");
            }
            ArrayList<Object> params = new ArrayList<Object>();
            for (int i = 0; i < varList.length; ++i) {
                Object value;
                String varName = varList[i];
                if (varName.startsWith("#")) continue;
                String varType = null;
                int typeIndex = varName.indexOf(58);
                if (typeIndex > 1) {
                    varType = varName.substring(0, typeIndex).toUpperCase();
                    varName = varName.substring(typeIndex + 1);
                }
                if (null == varType) {
                    try {
                        varType = pMeta.getParameterTypeName(i + 1);
                    }
                    catch (SQLException ex) {
                        String errMsg = "\u83b7\u53d6\u53d8\u91cf: '" + varName + "' \u6570\u636e\u7c7b\u578b\u65f6\u51fa\u9519 [" + ex.getClass().getSimpleName() + "] - " + ex.getMessage();
                        logger.warn(errMsg);
                    }
                }
                if (null == (value = values.get(varName))) {
                    throw new SQLException("\u627e\u4e0d\u5230\u53d8\u91cf: " + varName + "(" + sql + ")");
                }
                if (null != varType) {
                    value = JDBCConverter.jdbcObjectConvert(value, varType);
                }
                params.add(value);
            }
            TransSqlResult result = new TransSqlResult();
            result.parameterValues = params;
            result.preparableSql = pSql;
            TransSqlResult transSqlResult = result;
            return transSqlResult;
        }
        finally {
            if (null != pstmt) {
                pstmt.close();
            }
        }
    }

    public static interface ValueExtractor {
        public Object get(String var1);
    }

    public static class TransSqlResult {
        private String preparableSql;
        private List<Object> parameterValues;

        public String getPreparableSql() {
            return this.preparableSql;
        }

        public List<Object> getParameterValues() {
            return this.parameterValues;
        }
    }
}

