/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.jdbc;

import com.bokesoft.distro.tech.commons.basis.jdbc.mssql.SQLServerUtils;
import com.bokesoft.distro.tech.commons.basis.jdbc.struc.DBTypeCollection;
import com.bokesoft.distro.tech.commons.basis.jdbc.struc.DBTypeInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class DBTypeUtils {
    private static Logger logger = LoggerFactory.getLogger(DBTypeUtils.class);
    private static List<DBTypeInfo> dbTypeInfoCollection = DBTypeUtils.getByDefault();
    private static final String DBTYPE_INFO_FILE = "dbTypeInfo.yml";

    private static List<DBTypeInfo> getByDefault() {
        Yaml yaml = new Yaml();
        logger.info("\u6570\u636e\u5e93\u7c7b\u578b\u6620\u5c04\u5f00\u59cb\u52a0\u8f7d: {} ...", (Object)DBTYPE_INFO_FILE);
        DBTypeCollection defaultDBTypeCollection = (DBTypeCollection)yaml.loadAs(DBTypeUtils.class.getResourceAsStream(DBTYPE_INFO_FILE), DBTypeCollection.class);
        logger.info("\u6570\u636e\u5e93\u7c7b\u578b\u6620\u5c04\u52a0\u8f7d\u5b8c\u6210.");
        return defaultDBTypeCollection.getDbTypeInfos();
    }

    public static String getDBType(String jdbcUrl) {
        return DBTypeUtils.getDBTypeInfo(jdbcUrl).getDbType();
    }

    public static String getDBSubType(String jdbcUrl) {
        return DBTypeUtils.getDBTypeInfo(jdbcUrl).getSubType();
    }

    public static String getDBDriver(String jdbcUrl) {
        return DBTypeUtils.getDBTypeInfo(jdbcUrl).getDbDriver();
    }

    public static DBTypeInfo getDBTypeInfo(String jdbcUrl) {
        for (DBTypeInfo dbTypeInfo : DBTypeUtils.getAllDBtypTeInfos()) {
            if (!jdbcUrl.startsWith(dbTypeInfo.getJdbcUrlPattern())) continue;
            return dbTypeInfo;
        }
        throw new IllegalArgumentException("\u6682\u65f6\u4e0d\u652f\u6301 JDBC URL \u4e3a '" + jdbcUrl + "' \u7684\u6570\u636e\u5e93");
    }

    private static boolean isOracle(String url) {
        return null != url && DBTypeUtils.getDBType(url).equals("Oracle");
    }

    private static boolean isMySQL(String url) {
        return null != url && DBTypeUtils.getDBType(url).equals("MySQL");
    }

    private static boolean isSQLServer(String url) {
        return null != url && DBTypeUtils.getDBType(url).equals("SqlServer");
    }

    public static String getCountSql(String sql, String countColumnName, String jdbcUrl) {
        if (DBTypeUtils.isSQLServer(jdbcUrl)) {
            return SQLServerUtils.buildCountSqlWithoutOrderBy(sql, countColumnName);
        }
        return "SELECT COUNT(*) AS " + countColumnName + " FROM (" + sql + ") ALL_DATA";
    }

    public static String adaptSqlRange(String sql, int from, int size, String jdbcUrl) {
        if (DBTypeUtils.isOracle(jdbcUrl)) {
            return "SELECT * FROM (SELECT datas_.*, rownum rownum_ FROM (\n\t " + sql + "\n) datas_ WHERE rownum <= " + (from + size) + ") WHERE rownum_ > " + from;
        }
        if (DBTypeUtils.isMySQL(jdbcUrl)) {
            return sql + "\n\t Limit " + from + ", " + size;
        }
        if (DBTypeUtils.isSQLServer(jdbcUrl)) {
            return SQLServerUtils.adaptSqlRange(sql, from, size);
        }
        throw new UnsupportedOperationException("Unsupported jdbc connection type: " + jdbcUrl);
    }

    public static List<DBTypeInfo> getAllDBtypTeInfos() {
        return dbTypeInfoCollection;
    }
}

