/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.auth;

import com.bokesoft.distro.tech.commons.basis.auth.crossauth.CrossAuthData;
import com.bokesoft.distro.tech.commons.basis.auth.crossauth.CrossAuthTokenSetting;
import com.bokesoft.distro.tech.commons.basis.auth.crossauth.ICrossAuthTokenSettingProvider;
import com.bokesoft.yes.common.encrypt.RSA;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yigo.common.dependency.DependencySortCore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossAuthUtil {
    private static Logger logger = LoggerFactory.getLogger(CrossAuthUtil.class);
    public static final String AUTH_WILDCARD = "x-bk-cross-auth";
    private static List<ICrossAuthTokenSettingProvider> providers;

    public static void setup(List<ICrossAuthTokenSettingProvider> providers) {
        CrossAuthUtil.providers = DependencySortCore.sort(providers);
    }

    public static String build(String publicKey, CrossAuthData authData) {
        try {
            RSA rsa = new RSA();
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonStr = objectMapper.writeValueAsString((Object)authData);
            byte[] data = jsonStr.getBytes();
            data = rsa.encryptByPublic(data, publicKey);
            String result = new String(Base64.encode((byte[])data));
            return result;
        }
        catch (Exception e) {
            return (String)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static boolean doCheck(String privateKey, String authStr) {
        CrossAuthData authData = CrossAuthUtil.decrypt(privateKey, authStr);
        CrossAuthTokenSetting setting = CrossAuthUtil.matchReleatdTokenSetting(authData);
        if (null != setting) {
            return CrossAuthUtil.checkTokenData(authData, setting);
        }
        logger.warn("\u672a\u5339\u914d\u5230\u5408\u9002 callid = {} \u7684 Token \u9a8c\u8bc1\u914d\u7f6e,\u65e0\u6cd5\u9a8c\u8bc1\u6709\u6548\u6027", (Object)authData.getCallerId());
        return false;
    }

    protected static CrossAuthData decrypt(String privateKey, String authStr) {
        try {
            byte[] data = Base64.decode((byte[])authStr.getBytes());
            data = new RSA().decryptByPrivate(data, privateKey);
            String jsonStr = new String(data);
            ObjectMapper mapper = new ObjectMapper();
            CrossAuthData request = (CrossAuthData)mapper.readValue(jsonStr, CrossAuthData.class);
            return request;
        }
        catch (Throwable e) {
            logger.error("\u65e0\u6cd5\u89e3\u6790CrossAuth\u52a0\u5bc6\u4fe1\u606f", e);
            return (CrossAuthData)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    protected static boolean checkTokenData(CrossAuthData request, CrossAuthTokenSetting setting) {
        if (System.currentTimeMillis() < request.getApplyTime() + setting.getMaxTimeDriftMs() && System.currentTimeMillis() > request.getApplyTime() - setting.getMaxTimeDriftMs()) {
            String refToken = setting.getToken();
            if (request.getToken().equals(refToken)) {
                return true;
            }
        }
        return false;
    }

    private static CrossAuthTokenSetting matchReleatdTokenSetting(CrossAuthData authData) {
        for (ICrossAuthTokenSettingProvider authTokenSettingProvider : providers) {
            CrossAuthTokenSetting setting = authTokenSettingProvider.getAuthTokenSetting(authData.getCallerId());
            if (null == setting) continue;
            return setting;
        }
        return null;
    }
}

