package com.bokesoft.distro.tech.commons.basis.flightrecord.struc.bgtask;

import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * 使用quartz Job 的任务类型
 */
public enum TaskType {
    SINGLE_TASK(1,"单次任务"), SCHEDULED_TASK(2,"定时任务");

    private final int value;
    private final String caption;

    TaskType(int value, String caption) {
        this.value = value;
        this.caption = caption;
    }

    public int getValue() {
        return value;
    }
    public static TaskType fromValue(int value) {
        for (TaskType taskType : TaskType.values()) {
            if (taskType.getValue() == value) {
                return taskType;
            }
        }
        return null;
    }
    public static String getYigoComboBoxItems() {
        return Arrays.stream(TaskType.values())
                .map(a -> String.format("%s,%s", a.value,a.caption))
                .collect(Collectors.joining(";"));
    }
}
