package com.bokesoft.distro.tech.commons.basis.flightrecord.struc.bgtask;

import com.bokesoft.yigo.common.util.TypeConvertor;

import java.io.*;
import java.util.Map;

/**
 * quartz Job 运行过程中的监控日志
 */
public class QuartzJobEvent implements Serializable {

    private long occurTime;
    private String jobName;
    private String jobGroup;
    private String jobClassName;
    private String erpClientID;
    private long taskOperatorID;

    /**
     * 注意,在ERP源码中,key='YigoClientID '
     * com.bokesoft.yes.erp.backgroundtask.IBackGroundTask.java
     */
    private String yigoClientID;
    private String taskFormKey;
    private String formula;
    private String taskID;
    private String parameterFormula;
    private long currentOID;
    private long taskGroupID;

    /**
     * @deprecated 该字段和字段名executed已废弃, 请使用eventType;
     * 保留只是为了占位,防止持久层和历史数据出错
     */
    @Deprecated
    private boolean executed;

    private EventType eventType;

    private String error;
    private String operatorName;

    private long costMillis;
    private TaskType taskType;

    public long getOccurTime() {
        return occurTime;
    }

    public void setOccurTime(long occurTime) {
        this.occurTime = occurTime;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobGroup() {
        return jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public String getJobClassName() {
        return jobClassName;
    }

    public void setJobClassName(String jobClassName) {
        this.jobClassName = jobClassName;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getErpClientID() {
        return erpClientID;
    }

    public void setErpClientID(String erpClientID) {
        this.erpClientID = erpClientID;
    }

    public long getTaskOperatorID() {
        return taskOperatorID;
    }

    public void setTaskOperatorID(long taskOperatorID) {
        this.taskOperatorID = taskOperatorID;
    }

    public String getYigoClientID() {
        return yigoClientID;
    }

    public void setYigoClientID(String yigoClientID) {
        this.yigoClientID = yigoClientID;
    }

    public String getFormula() {
        return formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getTaskID() {
        return taskID;
    }

    public void setTaskID(String taskID) {
        this.taskID = taskID;
    }

    public String getParameterFormula() {
        return parameterFormula;
    }

    public void setParameterFormula(String parameterFormula) {
        this.parameterFormula = parameterFormula;
    }

    public long getCurrentOID() {
        return currentOID;
    }

    public void setCurrentOID(long currentOID) {
        this.currentOID = currentOID;
    }

    public long getTaskGroupID() {
        return taskGroupID;
    }

    public void setTaskGroupID(long taskGroupID) {
        this.taskGroupID = taskGroupID;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public long getCostMillis() {
        return costMillis;
    }

    public void setCostMillis(long costMillis) {
        this.costMillis = costMillis;
    }

    public EventType getEventType() {
        return eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public String getTaskFormKey() {
        return taskFormKey;
    }

    public void setTaskFormKey(String taskFormKey) {
        this.taskFormKey = taskFormKey;
    }

    public TaskType getTaskType() {
        return taskType;
    }

    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }

    public static void from(QuartzJobEvent event, Map<String, Object> data) {
        event.setOccurTime(TypeConvertor.toLong(data.get("occurTime")));
        event.setJobName(TypeConvertor.toString(data.get("jobName")));
        event.setJobClassName(TypeConvertor.toString(data.get("jobClassName")));
        event.setJobGroup(TypeConvertor.toString(data.get("jobGroup")));
        event.setErpClientID(TypeConvertor.toString(data.get("erpClientID")));
        event.setTaskOperatorID(TypeConvertor.toLong(data.get("taskOperatorID")));
        event.setYigoClientID(TypeConvertor.toString(data.get("yigoClientID")));
        event.setFormula(TypeConvertor.toString(data.get("formula")));
        event.setTaskID(TypeConvertor.toString(data.get("taskID")));
        event.setParameterFormula(TypeConvertor.toString(data.get("parameterFormula")));
        event.setCurrentOID(TypeConvertor.toLong(data.get("currentOID")));
        event.setTaskGroupID(TypeConvertor.toLong(data.get("taskGroupID")));
        event.setError(TypeConvertor.toString(data.get("error")));
        event.setOperatorName(TypeConvertor.toString(data.get("operatorName")));
        event.setCostMillis(TypeConvertor.toLong(data.get("costMillis")));
        event.setEventType(EventType.valueOf(TypeConvertor.toInteger(data.get("eventType"))));
        event.setTaskFormKey(TypeConvertor.toString(data.get("taskFormKey")));
        event.setTaskType(TaskType.fromValue(TypeConvertor.toInteger(data.get("taskType"))));
    }

    public static void to(QuartzJobEvent e, Map<String, Object> data) {
        data.put("occurTime", e.getOccurTime());
        data.put("jobName", e.getJobName());
        data.put("jobClassName", e.getJobClassName());
        data.put("jobGroup", e.getJobGroup());
        data.put("erpClientID", e.getErpClientID());
        data.put("taskOperatorID", e.getTaskOperatorID());
        data.put("yigoClientID", e.getYigoClientID());
        data.put("formula", e.getFormula());
        data.put("taskID", e.getTaskID());
        data.put("parameterFormula", e.getParameterFormula());
        data.put("currentOID", e.getCurrentOID());
        data.put("taskGroupID", e.getTaskGroupID());
        data.put("error", e.getError());
        data.put("operatorName", e.getOperatorName());
        data.put("costMillis", e.getCostMillis());
        data.put("taskFormKey", e.getTaskFormKey());
        if (e.getEventType() != null) {
            data.put("eventType", e.getEventType().getValue());
        }
        if (e.getTaskType() != null) {
            data.put("taskType", e.getTaskType().getValue());
        }
    }

}