package com.bokesoft.distro.tech.commons.basis.flightrecord.struc.database;

import java.io.Serializable;

import javax.sql.DataSource;

import com.bokesoft.distro.tech.commons.basis.flightrecord.config.FlightRecordToolsRegistry;
import com.bokesoft.distro.tech.commons.basis.flightrecord.utils.YFRUtils;

/** 数据库连接池配置信息 */
public class DatasourceCfgEvent implements Serializable {

    private String datasourceId;
    private long occurTime;
    private DatasourceCfgVO datasourceCfg;

    public String getDatasourceId() {
        return datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public long getOccurTime() {
        return occurTime;
    }

    public void setOccurTime(long occurTime) {
        this.occurTime = occurTime;
    }

    public DatasourceCfgVO getDatasourceCfg() {
        return datasourceCfg;
    }

    public void setDatasourceCfg(DatasourceCfgVO datasourceCfg) {
        this.datasourceCfg = datasourceCfg;
    }

    public static DatasourceCfgEvent build(DataSource datasource){
        DatasourceCfgEvent e = new DatasourceCfgEvent();
        e.datasourceId = YFRUtils.getDatasourceId(datasource);
        e.occurTime = System.currentTimeMillis();
        e.datasourceCfg = FlightRecordToolsRegistry.getDatasourceCfgResolver().build(datasource);
        return e;
    }

    public DatasourceCfgEvent(){
        //JSON 反序列化等场景需要
    }

    @Override
    public String toString() {
        return "DatasourceCfgEvent [datasourceId=" + datasourceId + ", datasourceCfg=" + datasourceCfg + "]";
    }
}
