/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.utils;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoRawConfiger;
import com.bokesoft.distro.tech.bootsupport.starter.api.ctx.ConfigerContext;
import com.bokesoft.distro.tech.bootsupport.starter.config.YigoCoreConfig;
import com.bokesoft.distro.tech.bootsupport.starter.datasource.DataSourceConfig;
import com.bokesoft.distro.tech.bootsupport.starter.deployment.SpringResourceMultiSolutionMetaResolverFactory;
import com.bokesoft.distro.tech.commons.basis.StringTemplate;
import com.bokesoft.distro.tech.commons.basis.jdbc.DBTypeUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.unbescape.properties.PropertiesEscape;
import org.unbescape.xml.XmlEscape;

public class YigoPropPreparationHelper {
    private static final Logger log = LoggerFactory.getLogger(YigoPropPreparationHelper.class);
    private static final String FILE_EXT_PROPERTIES = ".properties";
    private static final String FILE_EXT_XML = ".xml";
    private static final Pattern FILE_PATH_PATTERN = Pattern.compile("(^file://)(\\w+/)?(\\w+:)(/.*)?");
    private static ValueProvider valueProvider = null;
    private static List<String> pathVariableList = new ArrayList<String>();
    private static final String SYSTEM_TYPE = System.getProperty("os.name").toLowerCase();

    public static void setValueProvider(ValueProvider valueProvider) {
        YigoPropPreparationHelper.valueProvider = valueProvider;
    }

    public static void setPathVariableList(List<String> pathVariableList) {
        YigoPropPreparationHelper.pathVariableList = pathVariableList;
    }

    public static PrepareResult prepare(ResourceLoader loader, List<String> resources, List<YigoRawConfiger> configers, YigoCoreConfig yigoCoreConfig, DataSourceConfig dataSourceConfig) throws IOException {
        final Map<String, String> filesToWrite = YigoPropPreparationHelper.readSpringResources(loader, resources);
        if (YigoPropPreparationHelper.isSilentStart(filesToWrite, yigoCoreConfig)) {
            String workPath = YigoPropPreparationHelper.prepare(loader, filesToWrite);
            return new PrepareResult(workPath, true);
        }
        String corePropertiesStr = filesToWrite.get("core.properties");
        if (StringUtils.isBlank((CharSequence)corePropertiesStr)) {
            YigoPropPreparationHelper.buildDefaultCoreProperties(filesToWrite, yigoCoreConfig);
        }
        ConfigerContext context = new ConfigerContext(){

            @Override
            public String getFile(String fileName) {
                return (String)filesToWrite.get(fileName);
            }
        };
        YigoPropPreparationHelper.addCoreConfigSolutions(context, yigoCoreConfig.getSolutions(), filesToWrite);
        for (YigoRawConfiger configer : configers) {
            configer.prepare(context);
            filesToWrite.putAll(context.getAdditionalFiles());
        }
        YigoPropPreparationHelper.correctDsnProperties(loader, filesToWrite, yigoCoreConfig, dataSourceConfig);
        String workPath = YigoPropPreparationHelper.prepare(loader, filesToWrite);
        return new PrepareResult(workPath, filesToWrite, false);
    }

    private static boolean isSilentStart(Map<String, String> filesToWrite, YigoCoreConfig yigoCoreConfig) {
        String corePropertiesStr = filesToWrite.get("core.properties");
        return StringUtils.isBlank((CharSequence)corePropertiesStr) && (null == yigoCoreConfig.getSolutions() || yigoCoreConfig.getSolutions().isEmpty());
    }

    private static void addCoreConfigSolutions(ConfigerContext context, List<String> slnList, Map<String, String> filesToWriteMap) {
        if (CollectionUtils.isNotEmpty(slnList)) {
            for (int number = 0; number < slnList.size(); ++number) {
                String slnRes = YigoPropPreparationHelper.unifyFileResourceUrl(slnList.get(number));
                String slnName = "sln-" + number;
                context.addSolution(slnName, SpringResourceMultiSolutionMetaResolverFactory.class, SpringResourceMultiSolutionMetaResolverFactory.buildParas(slnRes));
            }
        }
        filesToWriteMap.putAll(context.getAdditionalFiles());
    }

    private static void buildDefaultCoreProperties(Map<String, String> filesToWrite, YigoCoreConfig yigoCoreConfig) throws IOException {
        Properties coreProps = new Properties();
        coreProps.setProperty("CACHE", yigoCoreConfig.getCache());
        coreProps.setProperty("KICK", yigoCoreConfig.getKick());
        coreProps.setProperty("DSN", yigoCoreConfig.getDsn());
        coreProps.setProperty("LOGSVR", yigoCoreConfig.getLogsvr());
        coreProps.setProperty("DEBUG", yigoCoreConfig.getDebug());
        coreProps.setProperty("ExternalBaseUrl", yigoCoreConfig.getExternalBaseUrl());
        coreProps.setProperty("_CREATED_BY", YigoPropPreparationHelper.class.getName());
        try (StringWriter sw = new StringWriter();){
            coreProps.store(sw, "Created by " + YigoPropPreparationHelper.class.getName());
            filesToWrite.put("core.properties", sw.toString());
        }
    }

    private static void correctDsnProperties(ResourceLoader loader, Map<String, String> filesToWrite, YigoCoreConfig yigoCoreConfig, DataSourceConfig dataSourceConfig) throws IOException {
        String corePropertiesStr = filesToWrite.get("core.properties");
        corePropertiesStr = YigoPropPreparationHelper.processTmpl(loader, "core.properties", corePropertiesStr, valueProvider);
        Properties coreProps = new Properties();
        try (StringReader sw = new StringReader(corePropertiesStr);){
            coreProps.load(sw);
            String dsnFile = coreProps.getProperty("DSN");
            String dsnFileContent = filesToWrite.get(dsnFile + FILE_EXT_PROPERTIES);
            if (StringUtils.isBlank((CharSequence)dsnFileContent)) {
                YigoPropPreparationHelper.buildDefaultDsnProperties(filesToWrite, dsnFile, yigoCoreConfig, dataSourceConfig);
            }
        }
    }

    private static void buildDefaultDsnProperties(Map<String, String> filesToWrite, String dnsFileName, YigoCoreConfig yigoCoreConfig, DataSourceConfig dataSourceConfig) throws IOException {
        Properties dsnProps = new Properties();
        String url = dataSourceConfig.getUrl();
        YigoPropPreparationHelper.setDsnDriver(url, dsnProps, dataSourceConfig);
        dsnProps.setProperty("Name", dnsFileName);
        dsnProps.setProperty("ConnectionType", yigoCoreConfig.getConnectionType());
        dsnProps.setProperty("URL", url);
        dsnProps.setProperty("User", dataSourceConfig.getUsername());
        dsnProps.setProperty("Password", dataSourceConfig.getPassword());
        dsnProps.setProperty("DBFactory", yigoCoreConfig.getDbFactory());
        try (StringWriter sw = new StringWriter();){
            dsnProps.store(sw, "Created by " + YigoPropPreparationHelper.class.getName());
            filesToWrite.put(dnsFileName + FILE_EXT_PROPERTIES, sw.toString());
        }
    }

    private static String prepare(ResourceLoader loader, Map<String, String> filesToWrite) throws IOException {
        File tmpPath = YigoPropPreparationHelper.buildYigoProperties(loader, filesToWrite);
        return tmpPath.getCanonicalPath();
    }

    private static Map<String, String> readSpringResources(ResourceLoader loader, List<String> resources) throws IOException {
        HashMap<String, String> filesToWrite = new HashMap<String, String>();
        for (String resource : resources) {
            Resource res = loader.getResource(resource = YigoPropPreparationHelper.unifyFileResourceUrl(resource));
            if (null != res && res.exists()) {
                String fileName = res.getFilename();
                if (null == fileName) {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u8d44\u6e90 '" + resource + "' - \u65e0\u6cd5\u5f97\u5230 file name");
                }
                String text = IOUtils.toString((InputStream)res.getInputStream(), (Charset)StandardCharsets.UTF_8);
                filesToWrite.put(fileName, text);
                continue;
            }
            throw new IOException("\u65e0\u6cd5\u52a0\u8f7d\u8d44\u6e90 '" + resource + "' - \u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return filesToWrite;
    }

    private static File buildYigoProperties(ResourceLoader loader, Map<String, String> filesToWrite) throws IOException {
        File tmpPath = YigoPropPreparationHelper.createTempClasspath();
        for (Map.Entry<String, String> en : filesToWrite.entrySet()) {
            String fileName = en.getKey();
            String content = YigoPropPreparationHelper.processTmpl(loader, fileName, en.getValue(), valueProvider);
            filesToWrite.put(fileName, content);
            File f = new File(tmpPath, fileName);
            FileUtils.writeStringToFile((File)f, (String)content, (String)"UTF-8");
        }
        return tmpPath;
    }

    private static void setDsnDriver(String url, Properties dsnProps, DataSourceConfig yigoDsConfig) {
        dsnProps.setProperty("DBType", DBTypeUtils.getDBType((String)url));
        dsnProps.setProperty("Driver", DBTypeUtils.getDBDriver((String)url));
    }

    private static File createTempClasspath() throws IOException {
        File tmpPath = Files.createTempDirectory(YigoPropPreparationHelper.class.getName() + "-" + Long.toString(System.currentTimeMillis()), new FileAttribute[0]).toFile();
        log.info("Yigo \u5c5e\u6027\u8bbe\u7f6e\u6587\u4ef6\u4e34\u65f6\u5b58\u653e\u76ee\u5f55: " + tmpPath);
        return tmpPath;
    }

    private static String processTmpl(ResourceLoader loader, String fileName, String tmplString, ValueProvider valueProvider) throws IOException {
        if (null == tmplString) {
            return "";
        }
        if (null == valueProvider) {
            return tmplString;
        }
        StringTemplate st = new StringTemplate(tmplString, "\\$\\{([^\\}]*)\\}");
        String[] vars = st.getVariables();
        for (int i = 0; i < vars.length; ++i) {
            String value;
            String var = vars[i];
            if (var.indexOf("include") == 0) {
                value = YigoPropPreparationHelper.includeAsContent(loader, var.substring(8));
            } else {
                value = valueProvider.getValue(var);
                if (pathVariableList.contains(var)) {
                    value = YigoPropPreparationHelper.formatPath(value);
                }
                if (fileName.endsWith(FILE_EXT_PROPERTIES)) {
                    value = YigoPropPreparationHelper.formatProperies(value);
                } else if (fileName.endsWith(FILE_EXT_XML)) {
                    value = YigoPropPreparationHelper.formatXml(value);
                }
            }
            st.setVariable(var, value);
        }
        return st.getParseResult();
    }

    private static String includeAsContent(ResourceLoader loader, String resourcePath) throws IOException {
        String result = null;
        Resource res = loader.getResource(resourcePath);
        if (null != res && res.exists()) {
            if (null == res.getFilename()) {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u8d44\u6e90 '" + resourcePath + "' - \u65e0\u6cd5\u5f97\u5230 file name");
            }
        } else {
            throw new IOException("\u65e0\u6cd5\u52a0\u8f7d\u8d44\u6e90 '" + resourcePath + "' - \u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String text = IOUtils.toString((InputStream)res.getInputStream(), (Charset)StandardCharsets.UTF_8);
        result = YigoPropPreparationHelper.processTmpl(loader, res.getFilename(), text, valueProvider);
        return result;
    }

    private static String formatPath(String pathValue) {
        if (StringUtils.isBlank((CharSequence)pathValue)) {
            return pathValue;
        }
        try {
            File f = new File(pathValue);
            Path p = Paths.get(f.toURI());
            pathValue = p.normalize().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        pathValue = YigoPropPreparationHelper.unifyFileResourceUrl(pathValue);
        return pathValue;
    }

    static String unifyFileResourceUrl(String pathValue) {
        if (pathValue.startsWith("file://")) {
            pathValue = pathValue.replaceAll("\\\\", "/");
            boolean isWin = SYSTEM_TYPE.startsWith("windows");
            Matcher matcher = FILE_PATH_PATTERN.matcher(pathValue);
            if (isWin && matcher.matches() && matcher.group(2) == null) {
                pathValue = matcher.group(1) + "/" + matcher.group(3) + (matcher.group(4) == null ? "" : matcher.group(4));
            }
            return pathValue;
        }
        return pathValue;
    }

    private static String formatProperies(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        value = PropertiesEscape.escapePropertiesValue((String)value);
        return value;
    }

    private static String formatXml(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        value = XmlEscape.escapeXml11((String)value);
        return value;
    }

    public static class PrepareResult {
        private String workPath;
        private boolean silentStart;
        private Map<String, String> filesToWrite;

        public PrepareResult(String workPath, boolean silentStart) {
            this(workPath, null, silentStart);
        }

        public PrepareResult(String workPath, Map<String, String> filesToWrite, boolean silentStart) {
            this.workPath = workPath;
            this.filesToWrite = filesToWrite;
            this.silentStart = silentStart;
        }

        public String getWorkPath() {
            return this.workPath;
        }

        public boolean isSilentStart() {
            return this.silentStart;
        }

        public Map<String, String> getFilesToWrite() {
            return this.filesToWrite;
        }
    }

    public static interface ValueProvider {
        public String getValue(String var1);
    }
}

