/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.execctl.utils;

import com.bokesoft.distro.tech.bootsupport.starter.config.ExecTimeoutCtrlConfig;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.config.dataobject.DataObjectCtrl;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.config.dataobject.DataObjectGroup;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.config.service.ServiceCtrl;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.config.service.ServiceGroup;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.exception.ExecTimeoutException;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.model.StartTimeObject;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.model.TimeoutConfig;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import jodd.util.Wildcard;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class ExecutionControlUtils {
    private static long defaultDbSqlTimeout;
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";

    public static void setDefaultDbSqlTimeout(long defaultDbSqlTimeout) {
        ExecutionControlUtils.defaultDbSqlTimeout = defaultDbSqlTimeout;
    }

    public static long calcAllocRemainedTime(ExecTimeoutCtrlConfig executionTimeoutControl, List<StartTimeObject> parallelSTOContainer, List<StartTimeObject> unParallelSTOContainer, Stack<String> dataObjectPaths, String serviceId, String instanceId) {
        List<StartTimeObject> startTimeObjects = ExecutionControlUtils.getReleatedStartTimeObjectList(parallelSTOContainer, unParallelSTOContainer, instanceId);
        TimeoutConfig timeoutConfig = ExecutionControlUtils.getTimeoutConfig(executionTimeoutControl, serviceId, dataObjectPaths);
        if (null != startTimeObjects && startTimeObjects.size() > 0) {
            long minEndTime = 0L;
            ArrayList<String> endTimeLogs = new ArrayList<String>();
            for (StartTimeObject startTimeObject : startTimeObjects) {
                String executionPoint;
                StartTimeObject.StartTimeObjectType type = startTimeObject.getType();
                Long timeoutMs = ExecutionControlUtils.getTimeoutMs(timeoutConfig, type, executionPoint = startTimeObject.getExecutionPoint());
                if (null == timeoutMs || 0L == timeoutMs) {
                    endTimeLogs.add((Object)((Object)startTimeObject.getType()) + "-EndTime:nolimit");
                    continue;
                }
                long startTime = startTimeObject.getStartTime();
                long endTime = startTime + timeoutMs;
                endTimeLogs.add((Object)((Object)type) + "-EndTime:" + DateFormatUtils.format((long)endTime, (String)DATE_PATTERN));
                if (0L == minEndTime) {
                    minEndTime = endTime;
                    continue;
                }
                minEndTime = Math.min(minEndTime, endTime);
            }
            if (0L != minEndTime) {
                long minTimeoutMs = minEndTime - System.currentTimeMillis();
                if (minTimeoutMs < 0L) {
                    String throwMsg = ExecutionControlUtils.getThrowExecutionTimeoutMsg(endTimeLogs);
                    throw new ExecTimeoutException(throwMsg);
                }
                return minTimeoutMs;
            }
        }
        return 0L;
    }

    private static List<StartTimeObject> getReleatedStartTimeObjectList(List<StartTimeObject> parallelSTOContainer, List<StartTimeObject> unParallelSTOContainer, String instanceId) {
        ArrayList<StartTimeObject> releatedStartTimeObjects = new ArrayList<StartTimeObject>();
        if (null != parallelSTOContainer && parallelSTOContainer.size() > 0) {
            if (StringUtils.isBlank((CharSequence)instanceId)) {
                releatedStartTimeObjects.addAll(parallelSTOContainer);
            } else {
                for (StartTimeObject startTimeObject : parallelSTOContainer) {
                    if (!StringUtils.equals((CharSequence)instanceId, (CharSequence)startTimeObject.getInstanceId())) continue;
                    releatedStartTimeObjects.add(startTimeObject);
                    break;
                }
            }
        }
        if (null != unParallelSTOContainer && unParallelSTOContainer.size() > 0) {
            releatedStartTimeObjects.addAll(unParallelSTOContainer);
        }
        return releatedStartTimeObjects;
    }

    private static TimeoutConfig getTimeoutConfig(ExecTimeoutCtrlConfig executionTimeoutControl, String serviceId, Stack<String> dataObjectPaths) {
        TimeoutConfig timeoutConfig = new TimeoutConfig();
        ExecutionControlUtils.getTimeoutConfigByService(timeoutConfig, executionTimeoutControl, serviceId);
        ExecutionControlUtils.getTimeoutConfigByDataObject(timeoutConfig, executionTimeoutControl, dataObjectPaths);
        return timeoutConfig;
    }

    private static void getTimeoutConfigByService(TimeoutConfig timeoutConfig, ExecTimeoutCtrlConfig executionTimeoutControl, String serviceId) {
        ServiceCtrl serviceCtrl = ExecutionControlUtils.getServiceCtrl(executionTimeoutControl, serviceId);
        if (null != serviceCtrl) {
            long requestTimeoutMs = serviceCtrl.getRequestTimeoutMs();
            long dbTransactionTimeoutMs = serviceCtrl.getDbTransactionTimeoutMs();
            long dbExecutionTimeoutMs = serviceCtrl.getDbExecutionTimeoutMs();
            timeoutConfig.setServiceTimeoutMs(requestTimeoutMs);
            timeoutConfig.setTransactionTimeoutMs(dbTransactionTimeoutMs);
            if (0L == dbExecutionTimeoutMs) {
                dbExecutionTimeoutMs = defaultDbSqlTimeout;
            }
            timeoutConfig.setDbExectionTimeoutMs(dbExecutionTimeoutMs);
        }
    }

    private static void getTimeoutConfigByDataObject(TimeoutConfig timeoutConfig, ExecTimeoutCtrlConfig executionTimeoutControl, Stack<String> dataObjectPaths) {
        if (null != dataObjectPaths && dataObjectPaths.size() > 0) {
            for (String dataObjectPath : dataObjectPaths) {
                DataObjectCtrl dataObjectCtrl = ExecutionControlUtils.getDataObjectCtrl(executionTimeoutControl, dataObjectPath);
                if (null == dataObjectCtrl) continue;
                long dataObjectTimeoutMs = dataObjectCtrl.getDataObjectTimeoutMs();
                long dbExecutionTimeoutMs = dataObjectCtrl.getDbExecutionTimeoutMs();
                Map<String, Long> dataObjectTimeoutMsMap = timeoutConfig.getDataObjectTimeoutMsMap();
                if (null == dataObjectTimeoutMsMap) {
                    dataObjectTimeoutMsMap = new HashMap<String, Long>();
                    timeoutConfig.setDataObjectTimeoutMsMap(dataObjectTimeoutMsMap);
                }
                dataObjectTimeoutMsMap.put(dataObjectPath, dataObjectTimeoutMs);
                if (0L == dbExecutionTimeoutMs) {
                    dbExecutionTimeoutMs = defaultDbSqlTimeout;
                }
                timeoutConfig.setDbExectionTimeoutMs(dbExecutionTimeoutMs);
            }
        }
    }

    private static String getThrowExecutionTimeoutMsg(List<String> endTimeLogs) {
        String msg = "stop execution due to timeout,{NOW:" + DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN) + "}";
        for (String endTimeLog : endTimeLogs) {
            msg = msg + ",{" + endTimeLog + "}";
        }
        return msg;
    }

    private static Long getTimeoutMs(TimeoutConfig timeoutConfig, StartTimeObject.StartTimeObjectType type, String executionPoint) {
        if (null != timeoutConfig) {
            switch (type) {
                case SERVICE: {
                    return timeoutConfig.getServiceTimeoutMs();
                }
                case TRANSACTION: {
                    return timeoutConfig.getTransactionTimeoutMs();
                }
                case DATAOBJECT: {
                    Long dataObjectTimeoutMs = null;
                    Map<String, Long> dataObjectTimeoutMsMap = timeoutConfig.getDataObjectTimeoutMsMap();
                    if (null != dataObjectTimeoutMsMap) {
                        dataObjectTimeoutMs = dataObjectTimeoutMsMap.get(executionPoint);
                    }
                    return dataObjectTimeoutMs;
                }
                case SQLEXECUTION: {
                    return timeoutConfig.getDbExectionTimeoutMs();
                }
            }
        }
        return 0L;
    }

    private static ServiceCtrl getServiceCtrl(ExecTimeoutCtrlConfig executionTimeoutControl, String serviceId) {
        List<ServiceGroup> serviceGroups;
        if (null == executionTimeoutControl || StringUtils.isBlank((CharSequence)serviceId)) {
            return null;
        }
        List<ServiceCtrl> serviceCtrls = executionTimeoutControl.getServiceCtrls();
        if (null == serviceCtrls) {
            serviceCtrls = new ArrayList<ServiceCtrl>();
        }
        if (null == (serviceGroups = executionTimeoutControl.getServiceGroups())) {
            serviceGroups = new ArrayList<ServiceGroup>();
        }
        HashMap patternsMap = new HashMap();
        for (ServiceGroup serviceGroup : serviceGroups) {
            ArrayList<String> mergePatterns = new ArrayList<String>();
            String groupName = serviceGroup.getName();
            List<String> patterns = serviceGroup.getPatterns();
            if (null != patterns && patterns.size() > 0) {
                mergePatterns.addAll(patterns);
            }
            patternsMap.put(groupName, mergePatterns);
        }
        for (ServiceCtrl serviceCtrl : serviceCtrls) {
            String groupName = serviceCtrl.getServiceGroup();
            List mergePatterns = (List)patternsMap.get(groupName);
            if (null == mergePatterns) {
                return null;
            }
            if (null != serviceCtrl.getPatterns()) {
                mergePatterns.addAll(serviceCtrl.getPatterns());
            }
            for (String pattern : mergePatterns) {
                if (!StringUtils.equals((CharSequence)pattern, (CharSequence)serviceId) && !Wildcard.matchPath((String)serviceId, (String)pattern)) continue;
                return serviceCtrl;
            }
        }
        return null;
    }

    private static DataObjectCtrl getDataObjectCtrl(ExecTimeoutCtrlConfig executionTimeoutControl, String dataObjectPath) {
        List<DataObjectGroup> dataObjectGroups;
        if (null == executionTimeoutControl || StringUtils.isBlank((CharSequence)dataObjectPath)) {
            return null;
        }
        List<DataObjectCtrl> dataObjectCtrls = executionTimeoutControl.getDataObjectCtrls();
        if (null == dataObjectCtrls) {
            dataObjectCtrls = new ArrayList<DataObjectCtrl>();
        }
        if (null == (dataObjectGroups = executionTimeoutControl.getDataObjectGroups())) {
            dataObjectGroups = new ArrayList<DataObjectGroup>();
        }
        HashMap patternsMap = new HashMap();
        for (DataObjectGroup dataObjectGroup : dataObjectGroups) {
            ArrayList<String> mergePatterns = new ArrayList<String>();
            String groupName = dataObjectGroup.getName();
            List<String> patterns = dataObjectGroup.getPatterns();
            if (null != patterns) {
                mergePatterns.addAll(patterns);
            }
            patternsMap.put(groupName, mergePatterns);
        }
        for (DataObjectCtrl dataObjectCtrl : dataObjectCtrls) {
            String groupName = dataObjectCtrl.getDataObjectGroup();
            List mergePatterns = (List)patternsMap.get(groupName);
            if (null == mergePatterns) {
                return null;
            }
            if (null != dataObjectCtrl.getPatterns()) {
                mergePatterns.addAll(dataObjectCtrl.getPatterns());
            }
            for (String pattern : mergePatterns) {
                if (!StringUtils.equals((CharSequence)pattern, (CharSequence)dataObjectPath) && !Wildcard.match((CharSequence)dataObjectPath, (CharSequence)pattern)) continue;
                return dataObjectCtrl;
            }
        }
        return null;
    }
}

