/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.execctl;

import com.bokesoft.distro.tech.bootsupport.starter.config.ExecTimeoutCtrlConfig;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.exception.ExecTimeoutException;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.model.StartTimeObject;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.utils.ExecutionControlUtils;
import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.ServiceIdPartsUtil;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.struct.document.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ExecutionTimeoutManager {
    private static ThreadLocal<String> tl_serviceId = new ThreadLocal();
    private static ThreadLocal<Stack<String>> tl_dataObjectPaths = new ThreadLocal();
    private static ThreadLocal<List<StartTimeObject>> tl_parallelSTOContainer = new ThreadLocal();
    private static ThreadLocal<List<StartTimeObject>> tl_unParallelSTOContainer = new ThreadLocal();
    private static ExecTimeoutCtrlConfig executionTimeoutControl;

    public static void setExecutionTimeoutControl(ExecTimeoutCtrlConfig executionTimeoutControl) {
        ExecutionTimeoutManager.executionTimeoutControl = executionTimeoutControl;
    }

    public static void init() {
        Stack dataObjectInstanceIds = new Stack();
        tl_dataObjectPaths.set(dataObjectInstanceIds);
        ArrayList parallelSTOContainer = new ArrayList();
        tl_parallelSTOContainer.set(parallelSTOContainer);
        ArrayList unParallelSTOContainer = new ArrayList();
        tl_unParallelSTOContainer.set(unParallelSTOContainer);
    }

    public static void reset() {
        tl_serviceId.remove();
        tl_dataObjectPaths.remove();
        tl_parallelSTOContainer.remove();
        tl_unParallelSTOContainer.remove();
    }

    public static void enterService(IServiceContext serviceContext, Map<String, Object> args) throws Throwable {
        String serviceId = ServiceIdPartsUtil.patchServiceId((IServiceContext)serviceContext, args);
        ExecutionTimeoutManager.enterService(serviceId);
    }

    static void enterService(String serviceId) {
        tl_serviceId.set(serviceId);
    }

    public static void exitService() {
        tl_serviceId.remove();
    }

    public static String enterDataObject(MetaDataObject dataObject) {
        String dataObjectPath = dataObject.getProjectKey() + "/" + dataObject.getKey();
        return ExecutionTimeoutManager.enterDataObject(dataObjectPath);
    }

    static String enterDataObject(String dataObjectPath) {
        ExecutionTimeoutManager.pushDataObjectPath(dataObjectPath);
        return dataObjectPath;
    }

    public static void exitDataObject() {
        ExecutionTimeoutManager.popDataObjectPath();
    }

    public static StartTimeObject getStartTimeObject(Document doc) {
        String dataObjectInstanceId = null == doc.getExpandData(StartTimeObject.class.getName()) ? "" : (String)doc.getExpandData(StartTimeObject.class.getName());
        List<StartTimeObject> startTimeObjects = tl_unParallelSTOContainer.get();
        if (null != startTimeObjects && startTimeObjects.size() > 0) {
            for (int i = startTimeObjects.size() - 1; i >= 0; --i) {
                StartTimeObject startTimeObject = startTimeObjects.get(i);
                String instanceId = startTimeObject.getInstanceId();
                if (!dataObjectInstanceId.equals(instanceId)) continue;
                return startTimeObject;
            }
        }
        return null;
    }

    public static void addStartTimeObject(StartTimeObject startTimeObject) {
        List<StartTimeObject> startTimeObjects;
        if (null != startTimeObject && null != (startTimeObjects = startTimeObject.isParallel() ? tl_parallelSTOContainer.get() : tl_unParallelSTOContainer.get())) {
            startTimeObjects.add(startTimeObject);
        }
    }

    public static void removeStartTimeObject(StartTimeObject startTimeObject) {
        List<StartTimeObject> startTimeObjects;
        if (null != startTimeObject && null != (startTimeObjects = startTimeObject.isParallel() ? tl_parallelSTOContainer.get() : tl_unParallelSTOContainer.get())) {
            startTimeObjects.remove(startTimeObject);
        }
    }

    public static long allocRemainedTime() throws ExecTimeoutException {
        return ExecutionTimeoutManager.allocRemainedTime(null);
    }

    public static long allocRemainedTime(String instanceId) throws ExecTimeoutException {
        return ExecutionControlUtils.calcAllocRemainedTime(executionTimeoutControl, tl_parallelSTOContainer.get(), tl_unParallelSTOContainer.get(), tl_dataObjectPaths.get(), tl_serviceId.get(), instanceId);
    }

    private static void pushDataObjectPath(String dataObjectPath) {
        Stack<String> dataObjectPaths = tl_dataObjectPaths.get();
        if (null != dataObjectPaths) {
            dataObjectPaths.push(dataObjectPath);
        }
    }

    private static String popDataObjectPath() {
        String dataObjectPath = "";
        Stack<String> dataObjectPaths = tl_dataObjectPaths.get();
        if (null != dataObjectPaths && dataObjectPaths.size() > 0) {
            dataObjectPath = dataObjectPaths.pop();
        }
        return dataObjectPath;
    }
}

