/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.deployment;

import com.bokesoft.distro.tech.bootsupport.starter.config.YigoModuleConfig;
import com.bokesoft.distro.tech.bootsupport.starter.deployment.SpringResourceIO;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.AbstractResourceMultiSolutionMetaResolverFactory;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.intf.IResourceIO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class SpringResourceMultiSolutionMetaResolverFactory
extends AbstractResourceMultiSolutionMetaResolverFactory {
    private static final Logger log = LoggerFactory.getLogger(SpringResourceMultiSolutionMetaResolverFactory.class);
    public static final String PARA_KEY_ROOT_RESOURCE = "ROOT_RESOURCE";
    public static final String PARA_KEY_IGNORE_RESOURCES = "IGNORE_RESOURCES";
    private static ResourceLoader RESOURCE_LOADER;
    private static List<String> IGNORE_SOLUTION_RESOURCES;
    private String rootResourcePath;
    private List<String> ignoreResourcePaths;

    public void initParas(Map<String, Object> paras) {
        this.rootResourcePath = (String)paras.get(PARA_KEY_ROOT_RESOURCE);
        if (StringUtils.isBlank((CharSequence)this.rootResourcePath)) {
            throw new IllegalArgumentException("Initial parameter invalid: 'ROOT_RESOURCE' is not defined.");
        }
        String ignoresStr = (String)paras.get(PARA_KEY_IGNORE_RESOURCES);
        if (StringUtils.isNotBlank((CharSequence)ignoresStr)) {
            this.ignoreResourcePaths = Arrays.asList(StringUtils.split((String)ignoresStr, (String)","));
        }
        super.initParas(paras);
    }

    @Autowired
    public void setResourceLoader(ResourceLoader resourceLoader) {
        RESOURCE_LOADER = resourceLoader;
    }

    @Autowired
    public void setYigoModuleConfig(YigoModuleConfig yigoModuleConfig) {
        IGNORE_SOLUTION_RESOURCES = yigoModuleConfig.getIgnoreSolutionResources();
        if (null != IGNORE_SOLUTION_RESOURCES && !IGNORE_SOLUTION_RESOURCES.isEmpty()) {
            log.warn("\u5df2\u5b9a\u4e49\u5168\u5c40 Yigo Solution \u8d44\u6e90\u8def\u5f84\u5ffd\u7565\u901a\u914d\u5217\u8868: \u6765\u81ea '{}' \u914d\u7f6e\u9879 , \u5305\u62ec\u5982\u4e0b Path Wildcard \u6a21\u5f0f: '{}'", (Object)"yigoee.tech.bootsupport.modules", IGNORE_SOLUTION_RESOURCES);
        }
    }

    protected IResourceIO getResourceIO() {
        return new SpringResourceIO(this.rootResourcePath, RESOURCE_LOADER, this.ignoreResourcePaths, IGNORE_SOLUTION_RESOURCES);
    }

    public static final Map<String, String> buildParas(String rootResourcePath) {
        return SpringResourceMultiSolutionMetaResolverFactory.buildParas(rootResourcePath, null);
    }

    public static final Map<String, String> buildParas(String rootResourcePath, List<String> ignoreResourcePaths) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(PARA_KEY_ROOT_RESOURCE, rootResourcePath);
        if (null != ignoreResourcePaths && ignoreResourcePaths.size() != 0) {
            result.put(PARA_KEY_IGNORE_RESOURCES, String.join((CharSequence)",", ignoreResourcePaths));
        }
        return result;
    }
}

