/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.configurer;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoAdditionalInitiator;
import com.bokesoft.distro.tech.bootsupport.starter.config.ExecTimeoutCtrlConfig;
import com.bokesoft.distro.tech.bootsupport.starter.datasource.DataSourceAwareDBManagerFactory;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.ExecutionTimeoutManager;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.utils.ExecutionControlUtils;
import com.bokesoft.distro.tech.bootsupport.starter.mid.filter.ExecutionTimeoutServiceFilter;
import com.bokesoft.distro.tech.bootsupport.starter.mid.process.PostExecutionTimeoutProcessFactory;
import com.bokesoft.distro.tech.bootsupport.starter.mid.process.PreExecutionTimeoutProcessFactory;
import com.bokesoft.yes.mid.service.MidProcessFlowHandler;
import com.bokesoft.yes.mid.service.filter.IFilterMatcher;
import com.bokesoft.yes.mid.service.filter.ServiceFilterFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceFilter;
import com.bokesoft.yigo.mid.service.IServiceProcessFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="yigoee.tech.bootsupport.execution-control", name={"enabled"}, havingValue="true")
public class ExecutionTimeoutConfigurer {
    @Bean
    public YigoAdditionalInitiator registerExecutionTimeoutServiceListener() {
        return new YigoAdditionalInitiator(){

            @Override
            public void init(DefaultContext context) throws Throwable {
                ServiceFilterFactory.getInstance().setMatcher(new IFilterMatcher(){

                    public List<IServiceFilter> find(String s, Map<String, Object> map) throws Throwable {
                        ArrayList<IServiceFilter> result = new ArrayList<IServiceFilter>();
                        result.add(new ExecutionTimeoutServiceFilter());
                        return result;
                    }
                });
            }
        };
    }

    @Bean
    public YigoAdditionalInitiator registerExcCtrlTimeOutSaveDataServiceListener() {
        return new YigoAdditionalInitiator(){

            @Override
            public void init(DefaultContext context) throws Throwable {
                MidProcessFlowHandler.addProcessFactory((String)"SaveData", (String)"Pre", (IServiceProcessFactory)new PreExecutionTimeoutProcessFactory());
                MidProcessFlowHandler.addProcessFactory((String)"SaveData", (String)"Post", (IServiceProcessFactory)new PostExecutionTimeoutProcessFactory());
            }
        };
    }

    @Bean
    public YigoAdditionalInitiator registerExcCtrlTimeOutDeleteDataServiceListener() {
        return new YigoAdditionalInitiator(){

            @Override
            public void init(DefaultContext context) throws Throwable {
                MidProcessFlowHandler.addProcessFactory((String)"DeleteData", (String)"Pre", (IServiceProcessFactory)new PreExecutionTimeoutProcessFactory());
                MidProcessFlowHandler.addProcessFactory((String)"DeleteData", (String)"Post", (IServiceProcessFactory)new PostExecutionTimeoutProcessFactory());
            }
        };
    }

    @Bean
    public YigoAdditionalInitiator registerExcCtrlTimeOutLoadDataServiceListener() {
        return new YigoAdditionalInitiator(){

            @Override
            public void init(DefaultContext context) throws Throwable {
                MidProcessFlowHandler.addProcessFactory((String)"LoadData", (String)"Pre", (IServiceProcessFactory)new PreExecutionTimeoutProcessFactory());
                MidProcessFlowHandler.addProcessFactory((String)"LoadData", (String)"Post", (IServiceProcessFactory)new PostExecutionTimeoutProcessFactory());
            }
        };
    }

    @Autowired
    public void setExecutionTimeoutControl(ExecTimeoutCtrlConfig timeoutControl) {
        ExecutionTimeoutManager.setExecutionTimeoutControl(timeoutControl);
        ExecutionControlUtils.setDefaultDbSqlTimeout(timeoutControl.getSqlTimeoutMs());
    }

    @Value(value="${yigoee.tech.bootsupport.execution-control.enabled:false}")
    private void setExecTimeoutControlEnabled(String execTimeoutControlEnabled) {
        DataSourceAwareDBManagerFactory.setExecTimeoutControlEnabled(Boolean.parseBoolean(execTimeoutControlEnabled));
    }
}

