/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.beans;

import com.bokesoft.distro.tech.bootsupport.starter.api.ctx.PageBuildContext;
import com.bokesoft.distro.tech.bootsupport.starter.beans.PagesBuildService;
import com.bokesoft.distro.tech.bootsupport.starter.config.YigoPagesConfig;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class PagesController {
    private final HttpServletRequest request;
    private final YigoPagesConfig pagesConfig;
    private final PagesBuildService pagesBuildService;

    public PagesController(HttpServletRequest request, YigoPagesConfig pagesConfig, PagesBuildService pagesBuildService) {
        this.request = request;
        this.pagesConfig = pagesConfig;
        this.pagesBuildService = pagesBuildService;
    }

    @RequestMapping(value={"/"})
    public ResponseEntity<String> welcomeFile(@CookieValue(value="clientID", defaultValue="") String clientID, @CookieValue(value="locale", defaultValue="") String locale) {
        return this.pagesBuildService.buildPage(this.pagesConfig.getDefaultPageResourceLocations().getMainframe(), PageBuildContext.build(this.request, PageBuildContext.PageClass.MAINFRAME), clientID, locale);
    }

    @RequestMapping(value={"${distro.tech.bootsupport.login-filter.main-page}"})
    public ResponseEntity<String> mainPureJsp(@CookieValue(value="clientID", defaultValue="") String clientID, @CookieValue(value="locale", defaultValue="") String locale) {
        return this.pagesBuildService.buildPage(this.pagesConfig.getDefaultPageResourceLocations().getMainframe(), PageBuildContext.build(this.request, PageBuildContext.PageClass.MAINFRAME), clientID, locale);
    }

    @RequestMapping(value={"${distro.tech.bootsupport.login-filter.mobile-main-page}"})
    public ResponseEntity<String> mobileHome(@CookieValue(value="clientID", defaultValue="") String clientID, @CookieValue(value="locale", defaultValue="") String locale) {
        return this.pagesBuildService.buildPage(this.pagesConfig.getDefaultPageResourceLocations().getMobileHome(), PageBuildContext.build(this.request, PageBuildContext.PageClass.MOBILEHOME), clientID, locale);
    }

    @RequestMapping(value={"${distro.tech.bootsupport.login-filter.login-page}"})
    public ResponseEntity<String> loginJsp(@CookieValue(value="clientID", defaultValue="") String clientID, @CookieValue(value="locale", defaultValue="") String locale) {
        return this.pagesBuildService.buildPage(this.pagesConfig.getDefaultPageResourceLocations().getLogin(), PageBuildContext.build(this.request, PageBuildContext.PageClass.LOGIN), clientID, locale);
    }

    @RequestMapping(value={"${distro.tech.bootsupport.login-filter.mobile-login-page}"})
    public ResponseEntity<String> appLogin(@CookieValue(value="clientID", defaultValue="") String clientID, @CookieValue(value="locale", defaultValue="") String locale) {
        return this.pagesBuildService.buildPage(this.pagesConfig.getDefaultPageResourceLocations().getMobileLogin(), PageBuildContext.build(this.request, PageBuildContext.PageClass.MOBILELOGIN), clientID, locale);
    }

    @RequestMapping(value={"${distro.tech.bootsupport.login-filter.waiting-page}"})
    public ResponseEntity<String> pcWaitingPage(@CookieValue(value="clientID", defaultValue="") String clientID, @CookieValue(value="locale", defaultValue="") String locale) {
        return this.pagesBuildService.buildPage(this.pagesConfig.getDefaultPageResourceLocations().getWaiting(), PageBuildContext.build(this.request, PageBuildContext.PageClass.WAITING), clientID, locale);
    }

    @RequestMapping(value={"${distro.tech.bootsupport.login-filter.mobile-waiting-page}"})
    public ResponseEntity<String> mobileWaitingPage(@CookieValue(value="clientID", defaultValue="") String clientID, @CookieValue(value="locale", defaultValue="") String locale) {
        return this.pagesBuildService.buildPage(this.pagesConfig.getDefaultPageResourceLocations().getMobileWaiting(), PageBuildContext.build(this.request, PageBuildContext.PageClass.MOBILEWAITING), clientID, locale);
    }
}

