/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.api.ctx;

import com.bokesoft.distro.tech.bootsupport.starter.utils.ServletUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import javax.servlet.http.HttpServletRequest;

public class PageBuildContext {
    private PageClass pageClass;
    private String pagePath;
    private DefaultContext defaultContext;

    public PageBuildContext(String pagePath) {
        this(PageClass.CUSTOM, pagePath);
    }

    public PageBuildContext(PageClass pageClass, String pagePath) {
        this.pageClass = pageClass;
        this.pagePath = pagePath;
    }

    public PageClass getPageClass() {
        return this.pageClass;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(DefaultContext context) {
        this.defaultContext = context;
    }

    public static PageBuildContext build(HttpServletRequest request, PageClass pageClass) {
        return new PageBuildContext(pageClass, ServletUtil.getFullServletPath(request));
    }

    public static PageBuildContext build(HttpServletRequest request) {
        return PageBuildContext.build(request, PageClass.CUSTOM);
    }

    public static enum PageClass {
        WAITING(101),
        LOGIN(102),
        MAINFRAME(103),
        MOBILEWAITING(201),
        MOBILELOGIN(202),
        MOBILEHOME(203),
        APPHOME(203),
        CUSTOM(999999);

        private int value;

        private PageClass(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

