package com.bokesoft.distro.tech.bootsupport.starter.utils;

import com.bokesoft.distro.tech.bootsupport.starter.servletcontextmocks.MockClassLoader;
import com.bokesoft.distro.tech.bootsupport.starter.servletcontextmocks.MockServletContext;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.json.JSONObject;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class YigoServiceInitHelper {
	/**
	 * Yigo 环境初始化
	 * @param prepareResult Yigo 配置准备
	 */
	public static void initYigoService(YigoPropPreparationHelper.PrepareResult prepareResult) throws Exception{
		initYigoService(prepareResult,false);
	}

	/**
	 * Yigo 环境初始化
	 * @param prepareResult Yigo 配置准备
	 * @param reload 重新加载标识   
	 */
	public static void initYigoService(YigoPropPreparationHelper.PrepareResult prepareResult,boolean reload) throws Exception{
		boolean useParams = false;
		Class<?> yigoInitializerClass = null;
		Class<?> yigoInitializerImplClass = null;
		try{
			yigoInitializerClass = Class.forName("com.bokesoft.yigo.mid.init.YigoInitializer");
			yigoInitializerImplClass = Class.forName("com.bokesoft.yes.mid.init.DefaultInitializer");
			useParams = null != prepareResult.getFilesToWrite() && prepareResult.getFilesToWrite().size() > 0;
		}catch(ClassNotFoundException e){
			// do nothing
		}
		//准备以 ClassLoader 替换的方式让 Yigo 从 workDir 启动
		ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
		ServletContextEvent se = null;
		try {
			//设置上下文的 ContextClassLoader, 以支持 Yigo 从 tmpPath 下获得配置文件
			Thread.currentThread().setContextClassLoader(new MockClassLoader(classLoader, prepareResult.getWorkPath()));
			if (useParams) {
			/*
			    通过反射实现下面代码
			    YigoInitializer.setInitializer(new DefaultInitializer(prepareResult.getWorkPath()));
				YigoInitializer.getInitializer().restart(params);
				或
				YigoInitializer.getInitializer().init();
			 */
				Map<String,Object> params = new HashMap<>();
				params.put("files", new JSONObject(prepareResult.getFilesToWrite()).toString());
				Constructor<?> constructor = yigoInitializerImplClass.getConstructor(String.class);
				Object instance = constructor.newInstance(prepareResult.getWorkPath());
				MethodUtils.invokeStaticMethod(yigoInitializerClass,"setInitializer",instance);
				if(reload) {
					MethodUtils.invokeMethod(instance, "restart", params);
				}else {
					MethodUtils.invokeMethod(instance, "init");
				}
				return;
			}else {
				// 如果不支持YigoInitializer.则使用ServerStart.start来启动
				//构造虚拟的 ServletContextEvent
				ServletContext sc = new MockServletContext(prepareResult.getWorkPath());
				se = new ServletContextEvent(sc);
		    /*因 Yigo 版本不同造成，部分 API 的 package 变化导致同一份代码无法兼容多个 Yigo 版本的情况，可以通过反射等技巧解决的.
		    新版本对yigo2的包名发生了更改，导致系统无法兼容。采用反射可以解决yigo版本适配的问题*/
				//调用 ServletContextListener: ServerStart
				Class<?> aClass = Class.forName("com.bokesoft.yigo.mid.init.ServerStart");
				aClass.getMethod("contextInitialized", ServletContextEvent.class).invoke(aClass.getDeclaredConstructor().newInstance(), se);
			}
		}catch (ClassNotFoundException e){
			Class<?> aClass = Class.forName("com.bokesoft.yes.mid.init.ServerStart");
			aClass.getMethod("contextInitialized", ServletContextEvent.class).invoke(aClass.getDeclaredConstructor().newInstance(),se);
		}finally {
			Thread.currentThread().setContextClassLoader(classLoader);
		}
	}

}
