package com.bokesoft.distro.tech.bootsupport.starter.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.bokesoft.distro.tech.bootsupport.starter.config.YigoCoreConfig;
import com.bokesoft.distro.tech.bootsupport.starter.datasource.DataSourceConfig;
import com.bokesoft.distro.tech.bootsupport.starter.utils.YigoPropPreparationHelper.PrepareResult;

import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoRawConfiger;

/**
 * 使用 SpringBoot 属性替换 Yigo properties 文件中的变量;
 */
public class YigoPropPreparation {
	/** 定义需要处理的 Yigo 配置文件模板资源 */
	private static final String PROPERTY_RESOURCES = "yigo2-distro.props-preparation.resources";
	/** 定义需要特别处理的配置变量类型 */
	private static final String PROPERTY_VAR_TYPES = "yigo2-distro.props-preparation.variable-types";
	/** 目前支持的特别配置变量类型：path - 需要进行 1.正反斜杠一致化; 2.去掉 .. 这样的路径 */
	private static final String PROPERTY_VAR_TYPE_PATH = "path";

	public static PrepareResult doPrepare(ApplicationContext appCtx) {
		final Environment env = appCtx.getEnvironment();

		final List<String> varsAsPath = readAsList(env, PROPERTY_VAR_TYPES + "." + PROPERTY_VAR_TYPE_PATH);
		YigoPropPreparationHelper.setPathVariableList(varsAsPath);

		YigoPropPreparationHelper.setValueProvider(new YigoPropPreparationHelper.ValueProvider() {
			@Override
			public String getValue(String variable) {
				return env.getProperty(variable);
			}
		});
		try {
			Map<String, YigoRawConfiger> configerBeans = appCtx.getBeansOfType(YigoRawConfiger.class);
			List<YigoRawConfiger> configers = new ArrayList<>(configerBeans.values());
			List<String> resources = readAsList(env, PROPERTY_RESOURCES);
			YigoCoreConfig yigoCoreConfig = appCtx.getBean(YigoCoreConfig.class);
			DataSourceConfig dataSourceConfig = appCtx.getBean(DataSourceConfig.class);
			return YigoPropPreparationHelper.prepare(appCtx, resources, configers,yigoCoreConfig,dataSourceConfig);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	private static List<String> readAsList(final Environment env, String key) {
		
		List<String> list = new ArrayList<>();
		for (int i = 0;; i++) {
			// List 在 env 中以 yigo2-distro.props-preparation.resources[0] 这样的属性存储
			String propKey = key + "[" + i + "]";
			String resource = env.getProperty(propKey);
			if (null == resource) {
				break;
			}
			list.add(resource);
		}
		return list;
	}

}
