package com.bokesoft.distro.tech.bootsupport.starter.servletcontextmocks;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.yes.mid.init.ServerStart;

/**
 * 模拟 WebApp 的上下文 ClassLoader 以支持 Yigo 正确找到 WorkDir;<br/>
 * Yigo 启动时从 {@link Thread#getContextClassLoader()} 中查找 core.properties 所在目录作为
 * WorkDir. 参考 {@link ServerStart#contextInitialized(javax.servlet.ServletContextEvent)}
 */
public class MockClassLoader extends ClassLoader {
	private static final Logger log = LoggerFactory.getLogger(MockClassLoader.class);
	
	private String tmpPath;

	public MockClassLoader(ClassLoader parent, String tmpPath) {
		super(parent);
		this.tmpPath = tmpPath;
	}

	@Override
	public URL getResource(String name) {
		Path path= Paths.get(this.tmpPath, name);
		if(Files.exists(path)){
			try {
				URL coreUrl = path.toUri().toURL();
				log.info("[Yigo 初始化]: {} 所在的 URL: {}", name, coreUrl);
				return coreUrl;
			} catch (MalformedURLException e) {
				throw MiscUtil.toRuntimeException(e);
			}
		}
		return super.getResource(name);
	}
}
