package com.bokesoft.distro.tech.bootsupport.starter.process;

import com.bokesoft.distro.tech.bootsupport.starter.runtime.YigoInstanceManager;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.model.InstanceStatus;
import com.bokesoft.yigo.mid.init.IInitProcess;

public class YigoInitProcess implements IInitProcess {
    private final YigoInstanceManager yigoInstanceManager;
    @Override
    public void initErrProcess(Throwable e){
        yigoInstanceManager.trans(yigoInstanceManager.getInstanceStatus().getStatus(),"Yigo 环境初始化失败", InstanceStatus.Status.ERROR, ()-> "Yigo 环境初始化失败");
        throw new RuntimeException("Yigo 环境初始化失败,"+e.getMessage(),e);
    }
    @Override
    public void destroyErrProcess(Throwable e) {
        yigoInstanceManager.trans(yigoInstanceManager.getInstanceStatus().getStatus(),"Yigo 环境卸载失败", InstanceStatus.Status.ERROR, ()-> "Yigo 环境卸载失败");
        throw new RuntimeException("Yigo 环境卸载失败,"+e.getMessage(),e);
    }

    public YigoInitProcess(YigoInstanceManager yigoInstanceManager) {
        this.yigoInstanceManager = yigoInstanceManager;
    }

    /**
     * yigo准备初始化
     * @param isRestart
     */
    @Override
    public void doPreInit(boolean isRestart) {
        yigoInstanceManager.trans(yigoInstanceManager.getInstanceStatus().getStatus(),"Yigo 准备初始化", InstanceStatus.Status.WAITING, ()-> "Yigo 准备初始化");
    }

    /**
     * yigo初始化完成
     * @param isRestart 是否重启
     */
    @Override
    public void doPostInit(boolean isRestart) {
        if(!YigoInstanceManager.BOOTING_WITH_SPRING_BOOT){
            yigoInstanceManager.bootLoad();
        }
    }
    /**
     * yigo准备卸载
     */
    @Override
    public void doPreDestroy() {
        yigoInstanceManager.trans(yigoInstanceManager.getInstanceStatus().getStatus(),"Yigo 环境准备卸载", InstanceStatus.Status.UNLOADING, ()-> "Yigo 环境开始卸载");
    }

    /**
     * yigo环境卸载完成
     */
    @Override
    public void doPostDestroy() {
        yigoInstanceManager.trans(yigoInstanceManager.getInstanceStatus().getStatus(),"Yigo 环境卸载成功", InstanceStatus.Status.WAITING, ()-> "Yigo 环境卸载成功");
    }
}
