package com.bokesoft.distro.tech.bootsupport.starter.mid.filter;

import com.bokesoft.distro.tech.bootsupport.starter.execctl.ExecutionTimeoutManager;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.model.StartTimeObject;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.service.IServiceFilter;

import java.util.Map;

public class ExecutionTimeoutServiceFilter implements IServiceFilter {

    private StartTimeObject startTimeObject;

    @Override
    public void preProcess(IServiceContext serviceContext, Map<String, Object> args) throws Throwable {
        //进入服务
        ExecutionTimeoutManager.enterService(serviceContext, args);

        //创建服务开始时间对象
        this.startTimeObject = StartTimeObject.buildServiceStartTimeObject();
        //添加服务开始时间对象
        ExecutionTimeoutManager.addStartTimeObject(startTimeObject);
    }

    @Override
    public void postProcess(IServiceContext iServiceContext, Map<String, Object> args) throws Throwable {

    }

    @Override
    public void errorProcess(IServiceContext iServiceContext, Map<String, Object> map, Throwable throwable) throws Throwable {

    }

    @Override
    public void finalProcess(IServiceContext serviceContext, Map<String, Object> args) throws Throwable {
        ExecutionTimeoutManager.removeStartTimeObject(startTimeObject);
        ExecutionTimeoutManager.exitService();
    }

    @Override
    public void checkSecurity(IServiceContext iServiceContext, Map<String, Object> map) throws Throwable {

    }


}
