package com.bokesoft.distro.tech.bootsupport.starter.execctl.recovery;

import java.sql.Connection;

import com.bokesoft.distro.tech.bootsupport.starter.execctl.recovery.flags.IUnmanagedRecoverProcess;

/**
 * 在数据库连接出现问题后, 执行恢复处理
 */
public interface IConnectionRecoverer {
    /**
     * 在发生数据库连接问题的现场执行, 用于记录必要的现场信息
     * @param connection 发生错误时的 Connection 对象
     */
    void prepare(Connection connection);

    /**
     * 在可以进行恢复处理的时点进行恢复操作
     * @param anotherConnection 目前假设所有的恢复操作都是通过数据库指令执行, 所以会提供一个新的 Connection 对象;
     *        注意对于标识为 {@link IUnmanagedRecoverProcess} 的 {@link IConnectionRecoverer}, 可以传入 null.
     *        另外, 此 Connection 不会自动被 commit, 如果相关操作必须 commit, 需要在 recover 代码中明确执行.
     */
    void recover(Connection anotherConnection);
}
