package com.bokesoft.distro.tech.bootsupport.starter.execctl.impl.recoverers;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.bokesoft.distro.tech.bootsupport.starter.execctl.recovery.IConnectionRecoverer;

/**
 * 适用于 MySQL 的 {@link IConnectionRecoverer} 实现
 */
public class MySqlStatementTimeoutRecoverer implements IConnectionRecoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlStatementTimeoutRecoverer.class);

    private int connId = -1;

    @Override
    public void prepare(Connection connection) {
        try {
            this.connId = getConnectionId(connection);
        } catch (SQLException e) {
            this.connId = -1;
            ExceptionUtils.rethrow(e);
        }
    }

    @Override
    public void recover(Connection newConn) {

            String killCmd = "kill " + this.connId;
            try {
                if(!newConn.isClosed()) {
                    QueryRunner runner = new QueryRunner();
                    runner.execute(newConn, killCmd);
                    LOGGER.warn("MySQL 问题恢复 - 执行 '{}' 成功 .", killCmd);
                }
            } catch (SQLException e) {
                LOGGER.error("MySQL 问题恢复 - 执行 '" + killCmd + "' 出现错误: " + e.getMessage(), e);
            }
    }

    private static int getConnectionId(Connection connection) throws SQLException{
        String sql = "select connection_id()";
        LOGGER.warn("MySQL 问题恢复 - 获取问题 Connection 的 ID: {} ...", sql);


        QueryRunner runner = new QueryRunner();

        int result = runner.query(connection, sql, resultSet->{
            resultSet.next();
            int connId = resultSet.getInt(1);
            return connId;
        });

        LOGGER.warn("MySQL 问题恢复 - 执行 '{}' 得到 Connection ID 为 {} .", sql, result);
        return result;
    }
}
