package com.bokesoft.distro.tech.bootsupport.starter.execctl.impl;

import java.sql.SQLTimeoutException;

import com.bokesoft.distro.tech.bootsupport.starter.execctl.impl.recoverers.MySqlStatementTimeoutRecoverer;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.impl.recoverers.WarnOnlyConnectionRecoverer;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.recovery.IConnectionRecoverer;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.recovery.IConnectionRecoveryFactory;
import com.bokesoft.yigo.mid.connection.DBType;

/**
 * 默认的 {@link IConnectionRecoveryFactory} 实现, 包括常用数据库的恢复过程
 */
public class DefaultConnectionRecoveryFactory implements IConnectionRecoveryFactory{

    @Override
    public IConnectionRecoverer buildRecoverer(int dbType, Exception ex) {
        if (ex instanceof SQLTimeoutException){
            if (DBType.MySql==dbType){
                return new MySqlStatementTimeoutRecoverer();
            }
            //FIXME ConnectionRecoveryFactory 需要支持 达梦、Oracle、SQL Server 等常用数据库
        }
        // 对于目前不支持的数据库, 返回 Warn only 的实现
        return new WarnOnlyConnectionRecoverer();
    }
    
}
