package com.bokesoft.distro.tech.bootsupport.starter.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties (prefix = "yigoee.tech.bootsupport.trace")
public class TraceConfig {
    private DbConfig db = new DbConfig();
    private DataRecordConfig drConfig = new DataRecordConfig();


    public void setDb(DbConfig db) {
        this.db = db;
    }

    public DbConfig getDb() {
        return db;
    }

    public DataRecordConfig getDrConfig() {
        return drConfig;
    }

    public void setDrConfig(DataRecordConfig drConfig) {
        this.drConfig = drConfig;
    }

    public static class DataRecordConfig{
        /** 数据记录队列长度 */
        private int limit = 30;
        /** 数据记录队列溢出处理策略 */
        private String overflowStrategy = "LOG_AND_DROP";

        public int getLimit() {
            return limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public String getOverflowStrategy() {
            return overflowStrategy;
        }

        public void setOverflowStrategy(String overflowStrategy) {
            this.overflowStrategy = overflowStrategy;
        }
    }

    public static class DbConfig{
        /**
         * 数据库执行sql日志的日志级别
         */
        private String logLevel = "DEBUG";

        public String getLogLevel() {
            return logLevel;
        }

        public void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }
    }
}
