package com.bokesoft.distro.tech.bootsupport.starter.config;

import com.bokesoft.distro.tech.bootsupport.starter.execctl.config.dataobject.DataObjectCtrl;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.config.dataobject.DataObjectGroup;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.config.service.ServiceCtrl;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.config.service.ServiceGroup;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * 超时时间管控
 */
@Configuration
@ConfigurationProperties(value = "yigoee.tech.bootsupport.execution-control")
public class ExecTimeoutCtrlConfig {

    /**
     * 服务组
     */
    private List<ServiceGroup> serviceGroups;

    /**
     * 服务
     */
    private List<ServiceCtrl> serviceCtrls;

    /**
     * DataObject组
     */
    private List<DataObjectGroup> dataObjectGroups;

    /**
     * 全局SQL默认执行超时限度
     */
    private long sqlTimeoutMs;

    /**
     * DataObject数据入口
     */
    private List<DataObjectCtrl> dataObjectCtrls;

    public List<ServiceGroup> getServiceGroups() {
        return serviceGroups;
    }

    public void setServiceGroups(List<ServiceGroup> serviceGroups) {
        this.serviceGroups = serviceGroups;
    }

    public List<ServiceCtrl> getServiceCtrls() {
        return serviceCtrls;
    }

    public void setServiceCtrls(List<ServiceCtrl> serviceCtrls) {
        this.serviceCtrls = serviceCtrls;
    }

    public List<DataObjectGroup> getDataObjectGroups() {
        return dataObjectGroups;
    }

    public void setDataObjectGroups(List<DataObjectGroup> dataObjectGroups) {
        this.dataObjectGroups = dataObjectGroups;
    }

    public List<DataObjectCtrl> getDataObjectCtrls() {
        return dataObjectCtrls;
    }

    public void setDataObjectCtrls(List<DataObjectCtrl> dataObjectCtrls) {
        this.dataObjectCtrls = dataObjectCtrls;
    }

    public long getSqlTimeoutMs() {
        return sqlTimeoutMs;
    }

    public void setSqlTimeoutMs(long sqlTimeoutMs) {
        this.sqlTimeoutMs = sqlTimeoutMs;
    }
}
