package com.bokesoft.distro.tech.bootsupport.starter.beans;

import com.bokesoft.distro.tech.bootsupport.starter.runtime.YigoInstanceManager;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.model.InstanceStatus;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(HealthController.HEALTH_REQUEST_PREFIX)
public class HealthController {
    public static final String HEALTH_REQUEST_PREFIX= "/health/yigo-container";

    @Autowired
    private YigoInstanceManager yigoInstanceManager;

    @RequestMapping("/status")
    public ResponseEntity<String> getYigoStatus() {
        InstanceStatus is = yigoInstanceManager.getInstanceStatus();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("status",is.getStatus());
        HttpHeaders headers = new HttpHeaders();
        headers.set(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_VALUE);
        return new ResponseEntity<>(jsonObject.toString(), headers, HttpStatus.OK);
    }
}
